/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public final class DomainUtils {
    private DomainUtils() {
    }

    public static <T> Map<Symbol, T> columnHandleToSymbol(Map<ColumnHandle, T> columnMap, Map<Symbol, ColumnHandle> assignments) {
        ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(assignments).inverse();
        Preconditions.checkArgument((boolean)inverseAssignments.keySet().containsAll(columnMap.keySet()), (Object)"assignments does not contain all required column handles");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, T> entry : columnMap.entrySet()) {
            builder.put(inverseAssignments.get(entry.getKey()), entry.getValue());
        }
        return builder.build();
    }

    public static Domain simplifyDomain(Domain domain) {
        ValueSet values = domain.getValues();
        ValueSet simplifiedValueSet = ((Optional)values.getValuesProcessor().transform(ranges -> {
            if (ranges.getOrderedRanges().size() <= 32) {
                return Optional.empty();
            }
            return Optional.of(ValueSet.ofRanges((Range)ranges.getSpan(), (Range[])new Range[0]));
        }, discreteValues -> {
            if (discreteValues.getValues().size() <= 32) {
                return Optional.empty();
            }
            return Optional.of(ValueSet.all((Type)domain.getType()));
        }, allOrNone -> Optional.empty())).orElse(values);
        return Domain.create((ValueSet)simplifiedValueSet, (boolean)domain.isNullAllowed());
    }
}

