/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilationException;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CursorProcessorCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ExpressionCompiler {
    private final Metadata metadata;
    private final LoadingCache<CacheKey, Class<? extends CursorProcessor>> cursorProcessors = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build((CacheLoader)new CacheLoader<CacheKey, Class<? extends CursorProcessor>>(){

        public Class<? extends CursorProcessor> load(CacheKey key) throws Exception {
            return ExpressionCompiler.this.compile(key.getFilter(), key.getProjections(), new CursorProcessorCompiler(ExpressionCompiler.this.metadata), CursorProcessor.class);
        }
    });

    @Inject
    public ExpressionCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Managed
    public long getCacheSize() {
        return this.cursorProcessors.size();
    }

    @Managed
    @Nested
    public CacheStatsMBean getCursorCacheStats() {
        return new CacheStatsMBean(this.cursorProcessors);
    }

    public Supplier<CursorProcessor> compileCursorProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections, Object uniqueKey) {
        Class cursorProcessor = (Class)this.cursorProcessors.getUnchecked((Object)new CacheKey(filter, projections, uniqueKey));
        return () -> {
            try {
                return (CursorProcessor)cursorProcessor.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    public Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections) {
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(this.metadata);
        Optional<Supplier> filterFunctionSupplier = filter.map(pageFunctionCompiler::compileFilter);
        List pageProjectionSuppliers = (List)projections.stream().map(pageFunctionCompiler::compileProjection).collect(ImmutableList.toImmutableList());
        return () -> {
            Optional<PageFilter> filterFunction = filterFunctionSupplier.map(Supplier::get);
            List pageProjections = (List)pageProjectionSuppliers.stream().map(Supplier::get).collect(ImmutableList.toImmutableList());
            return new PageProcessor(filterFunction, pageProjections);
        };
    }

    private <T> Class<? extends T> compile(Optional<RowExpression> filter, List<RowExpression> projections, BodyCompiler<T> bodyCompiler, Class<? extends T> superType) {
        try {
            return this.compileProcessor(filter.orElse(Expressions.constant(true, (Type)BooleanType.BOOLEAN)), projections, bodyCompiler, superType);
        }
        catch (CompilationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, e.getCause());
        }
    }

    private <T> Class<? extends T> compileProcessor(RowExpression filter, List<RowExpression> projections, BodyCompiler<T> bodyCompiler, Class<? extends T> superType) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)superType.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(superType)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        bodyCompiler.generateMethods(classDefinition, callSiteBinder, filter, projections);
        ExpressionCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString());
        return CompilerUtils.defineClass((ClassDefinition)classDefinition, superType, callSiteBinder.getBindings(), (ClassLoader)this.getClass().getClassLoader());
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString")).retObject();
    }

    private static final class CacheKey {
        private final Optional<RowExpression> filter;
        private final List<RowExpression> projections;
        private final Object uniqueKey;

        private CacheKey(Optional<RowExpression> filter, List<? extends RowExpression> projections, Object uniqueKey) {
            this.filter = filter;
            this.uniqueKey = uniqueKey;
            this.projections = ImmutableList.copyOf(projections);
        }

        private Optional<RowExpression> getFilter() {
            return this.filter;
        }

        private List<RowExpression> getProjections() {
            return this.projections;
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.projections, this.uniqueKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.filter, other.filter) && Objects.equals(this.projections, other.projections) && Objects.equals(this.uniqueKey, other.uniqueKey);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filter", this.filter).add("projections", this.projections).add("uniqueKey", this.uniqueKey).toString();
        }
    }
}

