/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

@DefunctConfig(value={"resource-group-manager", "experimental-syntax-enabled", "analyzer.experimental-syntax-enabled", "optimizer.processing-optimization"})
public class FeaturesConfig {
    private boolean distributedIndexJoinsEnabled;
    private boolean distributedJoinsEnabled = true;
    private boolean colocatedJoinsEnabled;
    private boolean fastInequalityJoins = true;
    private boolean reorderJoins = true;
    private boolean redistributeWrites = true;
    private boolean optimizeMetadataQueries;
    private boolean optimizeHashGeneration = true;
    private boolean optimizeSingleDistinct = true;
    private boolean enableIntermediateAggregations = false;
    private boolean pushTableWriteThroughUnion = true;
    private boolean exchangeCompressionEnabled = false;
    private boolean legacyArrayAgg;
    private boolean legacyOrderBy;
    private boolean legacyMapSubscript;
    private boolean optimizeMixedDistinctAggregations;
    private boolean dictionaryAggregation;
    private boolean resourceGroups;
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;
    private boolean spillEnabled;
    private DataSize operatorMemoryLimitBeforeSpill = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private List<Path> spillerSpillPaths = ImmutableList.of();
    private int spillerThreads = 4;
    private double spillMaxUsedSpaceThreshold = 0.9;
    private boolean iterativeOptimizerEnabled = true;
    private Duration iterativeOptimizerTimeout = new Duration(3.0, TimeUnit.MINUTES);

    public boolean isResourceGroupsEnabled() {
        return this.resourceGroups;
    }

    @Config(value="experimental.resource-groups-enabled")
    public FeaturesConfig setResourceGroupsEnabled(boolean enabled) {
        this.resourceGroups = enabled;
        return this;
    }

    public boolean isDistributedIndexJoinsEnabled() {
        return this.distributedIndexJoinsEnabled;
    }

    @Config(value="distributed-index-joins-enabled")
    public FeaturesConfig setDistributedIndexJoinsEnabled(boolean distributedIndexJoinsEnabled) {
        this.distributedIndexJoinsEnabled = distributedIndexJoinsEnabled;
        return this;
    }

    public boolean isDistributedJoinsEnabled() {
        return this.distributedJoinsEnabled;
    }

    @Config(value="deprecated.legacy-array-agg")
    public FeaturesConfig setLegacyArrayAgg(boolean legacyArrayAgg) {
        this.legacyArrayAgg = legacyArrayAgg;
        return this;
    }

    public boolean isLegacyArrayAgg() {
        return this.legacyArrayAgg;
    }

    @Config(value="deprecated.legacy-order-by")
    public FeaturesConfig setLegacyOrderBy(boolean value) {
        this.legacyOrderBy = value;
        return this;
    }

    public boolean isLegacyOrderBy() {
        return this.legacyOrderBy;
    }

    @Config(value="deprecated.legacy-map-subscript")
    public FeaturesConfig setLegacyMapSubscript(boolean value) {
        this.legacyMapSubscript = value;
        return this;
    }

    public boolean isLegacyMapSubscript() {
        return this.legacyMapSubscript;
    }

    @Config(value="distributed-joins-enabled")
    public FeaturesConfig setDistributedJoinsEnabled(boolean distributedJoinsEnabled) {
        this.distributedJoinsEnabled = distributedJoinsEnabled;
        return this;
    }

    public boolean isColocatedJoinsEnabled() {
        return this.colocatedJoinsEnabled;
    }

    @Config(value="colocated-joins-enabled")
    @ConfigDescription(value="Experimental: Use a colocated join when possible")
    public FeaturesConfig setColocatedJoinsEnabled(boolean colocatedJoinsEnabled) {
        this.colocatedJoinsEnabled = colocatedJoinsEnabled;
        return this;
    }

    @Config(value="fast-inequality-joins")
    @ConfigDescription(value="Experimental: Use faster handling of inequality joins if it is possible")
    public FeaturesConfig setFastInequalityJoins(boolean fastInequalityJoins) {
        this.fastInequalityJoins = fastInequalityJoins;
        return this;
    }

    public boolean isFastInequalityJoins() {
        return this.fastInequalityJoins;
    }

    public boolean isJoinReorderingEnabled() {
        return this.reorderJoins;
    }

    @Config(value="reorder-joins")
    @ConfigDescription(value="Experimental: Reorder joins to optimize plan")
    public FeaturesConfig setJoinReorderingEnabled(boolean reorderJoins) {
        this.reorderJoins = reorderJoins;
        return this;
    }

    public boolean isRedistributeWrites() {
        return this.redistributeWrites;
    }

    @Config(value="redistribute-writes")
    public FeaturesConfig setRedistributeWrites(boolean redistributeWrites) {
        this.redistributeWrites = redistributeWrites;
        return this;
    }

    public boolean isOptimizeMetadataQueries() {
        return this.optimizeMetadataQueries;
    }

    @Config(value="optimizer.optimize-metadata-queries")
    public FeaturesConfig setOptimizeMetadataQueries(boolean optimizeMetadataQueries) {
        this.optimizeMetadataQueries = optimizeMetadataQueries;
        return this;
    }

    public boolean isOptimizeHashGeneration() {
        return this.optimizeHashGeneration;
    }

    @Config(value="optimizer.optimize-hash-generation")
    public FeaturesConfig setOptimizeHashGeneration(boolean optimizeHashGeneration) {
        this.optimizeHashGeneration = optimizeHashGeneration;
        return this;
    }

    public boolean isOptimizeSingleDistinct() {
        return this.optimizeSingleDistinct;
    }

    @Config(value="optimizer.optimize-single-distinct")
    public FeaturesConfig setOptimizeSingleDistinct(boolean optimizeSingleDistinct) {
        this.optimizeSingleDistinct = optimizeSingleDistinct;
        return this;
    }

    public boolean isPushTableWriteThroughUnion() {
        return this.pushTableWriteThroughUnion;
    }

    @Config(value="optimizer.push-table-write-through-union")
    public FeaturesConfig setPushTableWriteThroughUnion(boolean pushTableWriteThroughUnion) {
        this.pushTableWriteThroughUnion = pushTableWriteThroughUnion;
        return this;
    }

    public boolean isDictionaryAggregation() {
        return this.dictionaryAggregation;
    }

    @Config(value="optimizer.dictionary-aggregation")
    public FeaturesConfig setDictionaryAggregation(boolean dictionaryAggregation) {
        this.dictionaryAggregation = dictionaryAggregation;
        return this;
    }

    @Min(value=2L)
    public int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-states-limit")
    public FeaturesConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=0L)
    public int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="re2j.dfa-retries")
    public FeaturesConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="regex-library")
    public FeaturesConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public boolean isSpillEnabled() {
        return this.spillEnabled;
    }

    @Config(value="experimental.spill-enabled")
    public FeaturesConfig setSpillEnabled(boolean spillEnabled) {
        this.spillEnabled = spillEnabled;
        return this;
    }

    public boolean isIterativeOptimizerEnabled() {
        return this.iterativeOptimizerEnabled;
    }

    @Config(value="experimental.iterative-optimizer-enabled")
    public FeaturesConfig setIterativeOptimizerEnabled(boolean value) {
        this.iterativeOptimizerEnabled = value;
        return this;
    }

    public Duration getIterativeOptimizerTimeout() {
        return this.iterativeOptimizerTimeout;
    }

    @Config(value="experimental.iterative-optimizer-timeout")
    public FeaturesConfig setIterativeOptimizerTimeout(Duration timeout) {
        this.iterativeOptimizerTimeout = timeout;
        return this;
    }

    public DataSize getOperatorMemoryLimitBeforeSpill() {
        return this.operatorMemoryLimitBeforeSpill;
    }

    @Config(value="experimental.operator-memory-limit-before-spill")
    public FeaturesConfig setOperatorMemoryLimitBeforeSpill(DataSize operatorMemoryLimitBeforeSpill) {
        this.operatorMemoryLimitBeforeSpill = operatorMemoryLimitBeforeSpill;
        return this;
    }

    public List<Path> getSpillerSpillPaths() {
        return this.spillerSpillPaths;
    }

    @Config(value="experimental.spiller-spill-path")
    public FeaturesConfig setSpillerSpillPaths(String spillPaths) {
        ImmutableList spillPathsSplit = ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)spillPaths));
        this.spillerSpillPaths = (List)spillPathsSplit.stream().map(path -> Paths.get(path, new String[0])).collect(ImmutableList.toImmutableList());
        return this;
    }

    public int getSpillerThreads() {
        return this.spillerThreads;
    }

    @Config(value="experimental.spiller-threads")
    public FeaturesConfig setSpillerThreads(int spillerThreads) {
        this.spillerThreads = spillerThreads;
        return this;
    }

    public double getSpillMaxUsedSpaceThreshold() {
        return this.spillMaxUsedSpaceThreshold;
    }

    @Config(value="experimental.spiller-max-used-space-threshold")
    public FeaturesConfig setSpillMaxUsedSpaceThreshold(double spillMaxUsedSpaceThreshold) {
        this.spillMaxUsedSpaceThreshold = spillMaxUsedSpaceThreshold;
        return this;
    }

    public boolean isOptimizeMixedDistinctAggregations() {
        return this.optimizeMixedDistinctAggregations;
    }

    @Config(value="optimizer.optimize-mixed-distinct-aggregations")
    public FeaturesConfig setOptimizeMixedDistinctAggregations(boolean value) {
        this.optimizeMixedDistinctAggregations = value;
        return this;
    }

    public boolean isExchangeCompressionEnabled() {
        return this.exchangeCompressionEnabled;
    }

    @Config(value="exchange.compression-enabled")
    public FeaturesConfig setExchangeCompressionEnabled(boolean exchangeCompressionEnabled) {
        this.exchangeCompressionEnabled = exchangeCompressionEnabled;
        return this;
    }

    public boolean isEnableIntermediateAggregations() {
        return this.enableIntermediateAggregations;
    }

    @Config(value="optimizer.enable-intermediate-aggregations")
    public FeaturesConfig setEnableIntermediateAggregations(boolean enableIntermediateAggregations) {
        this.enableIntermediateAggregations = enableIntermediateAggregations;
        return this;
    }
}

