/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.util.maps.IdentityLinkedHashMap;
import java.util.Objects;
import java.util.Set;

public class ExpressionAnalysis {
    private final IdentityLinkedHashMap<Expression, Type> expressionTypes;
    private final IdentityLinkedHashMap<Expression, Type> expressionCoercions;
    private final Set<Expression> typeOnlyCoercions;
    private final IdentityLinkedHashMap<Expression, FieldId> columnReferences;
    private final Set<InPredicate> subqueryInPredicates;
    private final Set<SubqueryExpression> scalarSubqueries;
    private final Set<ExistsPredicate> existsSubqueries;
    private final Set<QuantifiedComparisonExpression> quantifiedComparisons;
    private final IdentityLinkedHashMap<Identifier, LambdaArgumentDeclaration> lambdaArgumentReferences;

    public ExpressionAnalysis(IdentityLinkedHashMap<Expression, Type> expressionTypes, IdentityLinkedHashMap<Expression, Type> expressionCoercions, Set<InPredicate> subqueryInPredicates, Set<SubqueryExpression> scalarSubqueries, Set<ExistsPredicate> existsSubqueries, IdentityLinkedHashMap<Expression, FieldId> columnReferences, Set<Expression> typeOnlyCoercions, Set<QuantifiedComparisonExpression> quantifiedComparisons, IdentityLinkedHashMap<Identifier, LambdaArgumentDeclaration> lambdaArgumentReferences) {
        this.expressionTypes = Objects.requireNonNull(expressionTypes, "expressionTypes is null");
        this.expressionCoercions = Objects.requireNonNull(expressionCoercions, "expressionCoercions is null");
        this.typeOnlyCoercions = Objects.requireNonNull(typeOnlyCoercions, "typeOnlyCoercions is null");
        this.columnReferences = new IdentityLinkedHashMap<Expression, FieldId>(Objects.requireNonNull(columnReferences, "columnReferences is null"));
        this.subqueryInPredicates = Objects.requireNonNull(subqueryInPredicates, "subqueryInPredicates is null");
        this.scalarSubqueries = Objects.requireNonNull(scalarSubqueries, "subqueryInPredicates is null");
        this.existsSubqueries = Objects.requireNonNull(existsSubqueries, "existsSubqueries is null");
        this.quantifiedComparisons = Objects.requireNonNull(quantifiedComparisons, "quantifiedComparisons is null");
        this.lambdaArgumentReferences = Objects.requireNonNull(lambdaArgumentReferences, "lambdaArgumentReferences is null");
    }

    public Type getType(Expression expression) {
        return this.expressionTypes.get(expression);
    }

    public IdentityLinkedHashMap<Expression, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public Type getCoercion(Expression expression) {
        return this.expressionCoercions.get(expression);
    }

    public LambdaArgumentDeclaration getLambdaArgumentReference(Identifier qualifiedNameReference) {
        return this.lambdaArgumentReferences.get(qualifiedNameReference);
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(expression);
    }

    public boolean isColumnReference(Expression node) {
        return this.columnReferences.containsKey(node);
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Set<SubqueryExpression> getScalarSubqueries() {
        return this.scalarSubqueries;
    }

    public Set<ExistsPredicate> getExistsSubqueries() {
        return this.existsSubqueries;
    }

    public Set<QuantifiedComparisonExpression> getQuantifiedComparisons() {
        return this.quantifiedComparisons;
    }
}

