/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.util.maps.IdentityLinkedHashMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    private final Statement root;
    private final List<Expression> parameters;
    private String updateType;
    private final IdentityLinkedHashMap<Table, Query> namedQueries = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Node, Scope> scopes = new IdentityLinkedHashMap();
    private final IdentityHashMap<Expression, FieldId> columnReferences = new IdentityHashMap();
    private final IdentityLinkedHashMap<QuerySpecification, List<FunctionCall>> aggregates = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<OrderBy, List<Expression>> orderByAggregates = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<QuerySpecification, List<List<Expression>>> groupByExpressions = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Node, Expression> where = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<QuerySpecification, Expression> having = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Node, List<Expression>> orderByExpressions = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Node, List<Expression>> outputExpressions = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<QuerySpecification, List<FunctionCall>> windowFunctions = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<OrderBy, List<FunctionCall>> orderByWindowFunctions = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Join, Expression> joins = new IdentityLinkedHashMap();
    private final ListMultimap<Node, InPredicate> inPredicatesSubqueries = ArrayListMultimap.create();
    private final ListMultimap<Node, SubqueryExpression> scalarSubqueries = ArrayListMultimap.create();
    private final ListMultimap<Node, ExistsPredicate> existsSubqueries = ArrayListMultimap.create();
    private final ListMultimap<Node, QuantifiedComparisonExpression> quantifiedComparisonSubqueries = ArrayListMultimap.create();
    private final IdentityLinkedHashMap<Table, TableHandle> tables = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Expression, Type> types = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Expression, Type> coercions = new IdentityLinkedHashMap();
    private final Set<Expression> typeOnlyCoercions = Collections.newSetFromMap(new IdentityLinkedHashMap());
    private final IdentityLinkedHashMap<Relation, Type[]> relationCoercions = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<FunctionCall, Signature> functionSignature = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Identifier, LambdaArgumentDeclaration> lambdaArgumentReferences = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<Field, ColumnHandle> columns = new IdentityLinkedHashMap();
    private final IdentityLinkedHashMap<SampledRelation, Double> sampleRatios = new IdentityLinkedHashMap();
    private Optional<QualifiedObjectName> createTableDestination = Optional.empty();
    private Map<String, Expression> createTableProperties = ImmutableMap.of();
    private boolean createTableAsSelectWithData = true;
    private boolean createTableAsSelectNoOp = false;
    private Optional<String> createTableComment = Optional.empty();
    private Optional<Insert> insert = Optional.empty();
    private final boolean isDescribe;
    private final Deque<Table> tablesForView = new ArrayDeque<Table>();

    public Analysis(Statement root, List<Expression> parameters, boolean isDescribe) {
        Objects.requireNonNull(parameters);
        this.root = root;
        this.parameters = parameters;
        this.isDescribe = isDescribe;
    }

    public Statement getStatement() {
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean isCreateTableAsSelectWithData() {
        return this.createTableAsSelectWithData;
    }

    public void setCreateTableAsSelectWithData(boolean createTableAsSelectWithData) {
        this.createTableAsSelectWithData = createTableAsSelectWithData;
    }

    public boolean isCreateTableAsSelectNoOp() {
        return this.createTableAsSelectNoOp;
    }

    public void setCreateTableAsSelectNoOp(boolean createTableAsSelectNoOp) {
        this.createTableAsSelectNoOp = createTableAsSelectNoOp;
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put(node, aggregates);
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(query);
    }

    public void setOrderByAggregates(OrderBy node, List<Expression> aggregates) {
        this.orderByAggregates.put(node, (List<Expression>)ImmutableList.copyOf(aggregates));
    }

    public List<Expression> getOrderByAggregates(OrderBy query) {
        return this.orderByAggregates.get(query);
    }

    public IdentityLinkedHashMap<Expression, Type> getTypes() {
        return new IdentityLinkedHashMap<Expression, Type>(this.types);
    }

    public Type getType(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object)expression);
        return this.types.get(expression);
    }

    public Type getTypeWithCoercions(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object)expression);
        if (this.coercions.containsKey(expression)) {
            return this.coercions.get(expression);
        }
        return this.types.get(expression);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return this.relationCoercions.get(relation);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put(relation, types);
    }

    public IdentityLinkedHashMap<Expression, Type> getCoercions() {
        return this.coercions;
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(expression);
    }

    public void addLambdaArgumentReferences(IdentityLinkedHashMap<Identifier, LambdaArgumentDeclaration> lambdaArgumentReferences) {
        this.lambdaArgumentReferences.putAll(lambdaArgumentReferences);
    }

    public LambdaArgumentDeclaration getLambdaArgumentReference(Identifier identifier) {
        return this.lambdaArgumentReferences.get(identifier);
    }

    public IdentityLinkedHashMap<Identifier, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return this.lambdaArgumentReferences;
    }

    public void setGroupingSets(QuerySpecification node, List<List<Expression>> expressions) {
        this.groupByExpressions.put(node, expressions);
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(expression);
    }

    public List<List<Expression>> getGroupingSets(QuerySpecification node) {
        return this.groupByExpressions.get(node);
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put(node, expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(node);
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put(node, items);
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(node);
    }

    public void setOutputExpressions(Node node, List<Expression> expressions) {
        this.outputExpressions.put(node, expressions);
    }

    public List<Expression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(node);
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put(node, expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put(node, criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(join);
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        this.inPredicatesSubqueries.putAll((Object)node, expressionAnalysis.getSubqueryInPredicates());
        this.scalarSubqueries.putAll((Object)node, expressionAnalysis.getScalarSubqueries());
        this.existsSubqueries.putAll((Object)node, expressionAnalysis.getExistsSubqueries());
        this.quantifiedComparisonSubqueries.putAll((Object)node, expressionAnalysis.getQuantifiedComparisons());
    }

    public List<InPredicate> getInPredicateSubqueries(Node node) {
        if (this.inPredicatesSubqueries.containsKey((Object)node)) {
            return this.inPredicatesSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public List<SubqueryExpression> getScalarSubqueries(Node node) {
        if (this.scalarSubqueries.containsKey((Object)node)) {
            return this.scalarSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public List<ExistsPredicate> getExistsSubqueries(Node node) {
        if (this.existsSubqueries.containsKey((Object)node)) {
            return this.existsSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public List<QuantifiedComparisonExpression> getQuantifiedComparisonSubqueries(Node node) {
        if (this.quantifiedComparisonSubqueries.containsKey((Object)node)) {
            return this.quantifiedComparisonSubqueries.get((Object)node);
        }
        return ImmutableList.of();
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put(node, functions);
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(query);
    }

    public void setOrderByWindowFunctions(OrderBy node, List<FunctionCall> functions) {
        this.orderByWindowFunctions.put(node, (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getOrderByWindowFunctions(OrderBy query) {
        return this.orderByWindowFunctions.get(query);
    }

    public void addColumnReferences(IdentityLinkedHashMap<Expression, FieldId> columnReferences) {
        this.columnReferences.putAll(columnReferences);
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public Optional<Scope> tryGetScope(Node node) {
        if (this.scopes.containsKey(node)) {
            return Optional.of(this.scopes.get(node));
        }
        return Optional.empty();
    }

    public Scope getRootScope() {
        return this.getScope((Node)this.root);
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put(node, scope);
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor((Node)this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(table);
    }

    public Collection<TableHandle> getTables() {
        return this.tables.values();
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put(table, handle);
    }

    public Signature getFunctionSignature(FunctionCall function) {
        return this.functionSignature.get(function);
    }

    public void addFunctionSignatures(IdentityLinkedHashMap<FunctionCall, Signature> infos) {
        this.functionSignature.putAll(infos);
    }

    public Set<Expression> getColumnReferences() {
        return Collections.unmodifiableSet(this.columnReferences.keySet());
    }

    public Map<Expression, FieldId> getColumnReferenceFields() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public void addTypes(IdentityLinkedHashMap<Expression, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put(expression, type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add(expression);
        }
    }

    public void addCoercions(IdentityLinkedHashMap<Expression, Type> coercions, Set<Expression> typeOnlyCoercions) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(query);
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setCreateTableDestination(QualifiedObjectName destination) {
        this.createTableDestination = Optional.of(destination);
    }

    public Optional<QualifiedObjectName> getCreateTableDestination() {
        return this.createTableDestination;
    }

    public void setCreateTableProperties(Map<String, Expression> createTableProperties) {
        this.createTableProperties = createTableProperties;
    }

    public Map<String, Expression> getCreateTableProperties() {
        return this.createTableProperties;
    }

    public void setCreateTableComment(Optional<String> createTableComment) {
        this.createTableComment = Objects.requireNonNull(createTableComment);
    }

    public Optional<String> getCreateTableComment() {
        return this.createTableComment;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(table);
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put(tableReference, query);
    }

    public void registerTableForView(Table tableReference) {
        this.tablesForView.push(Objects.requireNonNull(tableReference, "table is null"));
    }

    public void unregisterTableForView() {
        this.tablesForView.pop();
    }

    public boolean hasTableInView(Table tableReference) {
        return this.tablesForView.contains(tableReference);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put(relation, ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(relation), (String)"Sample ratio missing for %s. Broken analysis?", (Object)relation);
        return this.sampleRatios.get(relation);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public boolean isDescribe() {
        return this.isDescribe;
    }

    @Immutable
    public static final class Insert {
        private final TableHandle target;
        private final List<ColumnHandle> columns;

        public Insert(TableHandle target, List<ColumnHandle> columns) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }
    }
}

