/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.FramedWindowFunction;
import com.facebook.presto.operator.window.PagesWindowIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.WindowIndex;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class WindowPartition {
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;
    private final int[] outputChannels;
    private final List<FramedWindowFunction> windowFunctions;
    private final PagesHashStrategy peerGroupHashStrategy;
    private int peerGroupStart;
    private int peerGroupEnd;
    private int currentPosition;

    public WindowPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<FramedWindowFunction> windowFunctions, PagesHashStrategy peerGroupHashStrategy) {
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.outputChannels = outputChannels;
        this.windowFunctions = ImmutableList.copyOf(windowFunctions);
        this.peerGroupHashStrategy = peerGroupHashStrategy;
        PagesWindowIndex windowIndex = new PagesWindowIndex(pagesIndex, partitionStart, partitionEnd);
        for (FramedWindowFunction framedWindowFunction : windowFunctions) {
            framedWindowFunction.getFunction().reset((WindowIndex)windowIndex);
        }
        this.currentPosition = partitionStart;
        this.updatePeerGroup();
    }

    public int getPartitionEnd() {
        return this.partitionEnd;
    }

    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    public void processNextRow(PageBuilder pageBuilder) {
        int channel;
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more rows in partition");
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        if (this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        for (FramedWindowFunction framedFunction : this.windowFunctions) {
            Range range = this.getFrameRange(framedFunction.getFrame());
            framedFunction.getFunction().processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, range.getStart(), range.getEnd());
            ++channel;
        }
        ++this.currentPosition;
    }

    private void updatePeerGroup() {
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.pagesIndex.positionEqualsPosition(this.peerGroupHashStrategy, this.peerGroupStart, this.peerGroupEnd)) {
            ++this.peerGroupEnd;
        }
    }

    private Range getFrameRange(FrameInfo frameInfo) {
        int rowPosition = this.currentPosition - this.partitionStart;
        int endPosition = this.partitionEnd - this.partitionStart - 1;
        if (this.emptyFrame(frameInfo, rowPosition, endPosition)) {
            return new Range(-1, -1);
        }
        int frameStart = frameInfo.getStartType() == FrameBound.Type.UNBOUNDED_PRECEDING ? 0 : (frameInfo.getStartType() == FrameBound.Type.PRECEDING ? WindowPartition.preceding(rowPosition, this.getStartValue(frameInfo)) : (frameInfo.getStartType() == FrameBound.Type.FOLLOWING ? WindowPartition.following(rowPosition, endPosition, this.getStartValue(frameInfo)) : (frameInfo.getType() == WindowFrame.Type.RANGE ? this.peerGroupStart - this.partitionStart : rowPosition)));
        int frameEnd = frameInfo.getEndType() == FrameBound.Type.UNBOUNDED_FOLLOWING ? endPosition : (frameInfo.getEndType() == FrameBound.Type.PRECEDING ? WindowPartition.preceding(rowPosition, this.getEndValue(frameInfo)) : (frameInfo.getEndType() == FrameBound.Type.FOLLOWING ? WindowPartition.following(rowPosition, endPosition, this.getEndValue(frameInfo)) : (frameInfo.getType() == WindowFrame.Type.RANGE ? this.peerGroupEnd - this.partitionStart - 1 : rowPosition)));
        return new Range(frameStart, frameEnd);
    }

    private boolean emptyFrame(FrameInfo frameInfo, int rowPosition, int endPosition) {
        FrameBound.Type startType = frameInfo.getStartType();
        FrameBound.Type endType = frameInfo.getEndType();
        int positions = endPosition - rowPosition;
        if (startType == FrameBound.Type.UNBOUNDED_PRECEDING && endType == FrameBound.Type.PRECEDING) {
            return this.getEndValue(frameInfo) > (long)rowPosition;
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
            return this.getStartValue(frameInfo) > (long)positions;
        }
        if (startType != endType) {
            return false;
        }
        FrameBound.Type type = frameInfo.getStartType();
        if (type != FrameBound.Type.PRECEDING && type != FrameBound.Type.FOLLOWING) {
            return false;
        }
        long start = this.getStartValue(frameInfo);
        long end = this.getEndValue(frameInfo);
        if (type == FrameBound.Type.PRECEDING) {
            return start < end || start > (long)rowPosition && end > (long)rowPosition;
        }
        return start > end || start > (long)positions && end > (long)positions;
    }

    private static int preceding(int rowPosition, long value) {
        if (value > (long)rowPosition) {
            return 0;
        }
        return Math.toIntExact((long)rowPosition - value);
    }

    private static int following(int rowPosition, int endPosition, long value) {
        if (value > (long)(endPosition - rowPosition)) {
            return endPosition;
        }
        return Math.toIntExact((long)rowPosition + value);
    }

    private long getStartValue(FrameInfo frameInfo) {
        return this.getFrameValue(frameInfo.getStartChannel(), "starting");
    }

    private long getEndValue(FrameInfo frameInfo) {
        return this.getFrameValue(frameInfo.getEndChannel(), "ending");
    }

    private long getFrameValue(int channel, String type) {
        Failures.checkCondition(!this.pagesIndex.isNull(channel, this.currentPosition), (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be null", type);
        long value = this.pagesIndex.getLong(channel, this.currentPosition);
        Failures.checkCondition(value >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be negative", value);
        return value;
    }

    private static class Range {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

