/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ParametricScalar;
import com.facebook.presto.operator.scalar.annotations.OperatorValidator;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementation;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementationHeader;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementations;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class ScalarFromAnnotationsParser {
    private ScalarFromAnnotationsParser() {
    }

    public static List<SqlScalarFunction> parseFunctionDefinition(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods scalar : ScalarFromAnnotationsParser.findScalarsInFunctionDefinitionClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(scalar, ScalarFromAnnotationsParser.findConstructors(clazz)));
        }
        return builder.build();
    }

    public static List<SqlScalarFunction> parseFunctionDefinitions(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods methods : ScalarFromAnnotationsParser.findScalarsInFunctionSetClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(methods, ScalarFromAnnotationsParser.findConstructors(clazz)));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionDefinitionClass(Class<?> annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<ScalarImplementationHeader> classHeaders = ScalarImplementationHeader.fromAnnotatedElement(annotated);
        Preconditions.checkArgument((!classHeaders.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] that defines function must be annotated with @ScalarFunction or @ScalarOperator", (Object)annotated.getName());
        for (ScalarImplementationHeader header : classHeaders) {
            Set<Method> methods = ScalarFromAnnotationsParser.findPublicMethodsWithAnnotation(annotated, SqlType.class, ScalarFunction.class, ScalarOperator.class);
            Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"Parametric class [%s] does not have any annotated methods", (Object)annotated.getName());
            for (Method method : methods) {
                Preconditions.checkArgument((method.getAnnotation(ScalarFunction.class) == null ? 1 : 0) != 0, (String)"Parametric class method [%s] is annotated with @ScalarFunction", (Object)method);
                Preconditions.checkArgument((method.getAnnotation(ScalarOperator.class) == null ? 1 : 0) != 0, (String)"Parametric class method [%s] is annotated with @ScalarOperator", (Object)method);
            }
            builder.add((Object)new ScalarHeaderAndMethods(header, methods));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionSetClass(Class<?> annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : ScalarFromAnnotationsParser.findPublicMethodsWithAnnotation(annotated, SqlType.class, ScalarFunction.class, ScalarOperator.class)) {
            Preconditions.checkArgument((method.getAnnotation(ScalarFunction.class) != null || method.getAnnotation(ScalarOperator.class) != null ? 1 : 0) != 0, (String)"Method [%s] annotated with @SqlType is missing @ScalarFunction or @ScalarOperator", (Object)method);
            for (ScalarImplementationHeader header : ScalarImplementationHeader.fromAnnotatedElement(method)) {
                builder.add((Object)new ScalarHeaderAndMethods(header, (Set<Method>)ImmutableSet.of((Object)method)));
            }
        }
        ImmutableList methods = builder.build();
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] does not have any methods annotated with @ScalarFunction or @ScalarOperator", (Object)annotated.getName());
        return methods;
    }

    private static SqlScalarFunction parseParametricScalar(ScalarHeaderAndMethods scalar, Map<Set<TypeParameter>, Constructor<?>> constructors) {
        ImmutableMap.Builder exactImplementations = ImmutableMap.builder();
        ImmutableList.Builder specializedImplementations = ImmutableList.builder();
        ImmutableList.Builder genericImplementations = ImmutableList.builder();
        Optional<Signature> signature = Optional.empty();
        ScalarImplementationHeader header = scalar.getHeader();
        Preconditions.checkArgument((!header.getName().isEmpty() ? 1 : 0) != 0);
        for (Method method : scalar.getMethods()) {
            ScalarImplementation implementation = ScalarImplementation.Parser.parseImplementation(header.getName(), method, constructors);
            if (implementation.getSignature().getTypeVariableConstraints().isEmpty() && implementation.getSignature().getArgumentTypes().stream().noneMatch(TypeSignature::isCalculated) && !implementation.getSignature().getReturnType().isCalculated()) {
                exactImplementations.put((Object)implementation.getSignature(), (Object)implementation);
                continue;
            }
            if (implementation.hasSpecializedTypeParameters()) {
                specializedImplementations.add((Object)implementation);
            } else {
                genericImplementations.add((Object)implementation);
            }
            signature = signature.isPresent() ? signature : Optional.of(implementation.getSignature());
            ScalarFromAnnotationsParser.validateSignature(signature, implementation.getSignature());
        }
        Signature scalarSignature = signature.orElseGet(() -> (Signature)Iterables.getOnlyElement((Iterable)exactImplementations.build().keySet()));
        header.getOperatorType().ifPresent(operatorType -> OperatorValidator.validateOperator(operatorType, scalarSignature.getReturnType(), scalarSignature.getArgumentTypes()));
        ScalarImplementations implementations = new ScalarImplementations((Map<Signature, ScalarImplementation>)exactImplementations.build(), (List<ScalarImplementation>)specializedImplementations.build(), (List<ScalarImplementation>)genericImplementations.build());
        return new ParametricScalar(scalarSignature, header.getHeader(), implementations);
    }

    private static void validateSignature(Optional<Signature> signatureOld, Signature signatureNew) {
        if (!signatureOld.isPresent()) {
            return;
        }
        Preconditions.checkArgument((boolean)signatureOld.get().equals(signatureNew), (String)"Implementations with type parameters must all have matching signatures. %s does not match %s", (Object)signatureOld.get(), (Object)signatureNew);
    }

    private static Map<Set<TypeParameter>, Constructor<?>> findConstructors(Class<?> clazz) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            HashSet typeParameters = new HashSet();
            Stream.of(constructor.getAnnotationsByType(TypeParameter.class)).forEach(typeParameters::add);
            builder.put(typeParameters, constructor);
        }
        return builder.build();
    }

    @SafeVarargs
    private static Set<Method> findPublicMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> ... annotationClasses) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                for (Class<? extends Annotation> annotationClass : annotationClasses) {
                    if (!annotationClass.isInstance(annotation)) continue;
                    Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"Method [%s] annotated with @%s must be public", (Object)method, (Object)annotationClass.getSimpleName());
                    methods.add((Object)method);
                }
            }
        }
        return methods.build();
    }

    private static class ScalarHeaderAndMethods {
        private final ScalarImplementationHeader header;
        private final Set<Method> methods;

        public ScalarHeaderAndMethods(ScalarImplementationHeader header, Set<Method> methods) {
            this.header = Objects.requireNonNull(header);
            this.methods = Objects.requireNonNull(methods);
        }

        public ScalarImplementationHeader getHeader() {
            return this.header;
        }

        public Set<Method> getMethods() {
            return this.methods;
        }
    }
}

