/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.scalar.RowComparisonOperator;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class RowLessThanOperator
extends RowComparisonOperator {
    public static final RowLessThanOperator ROW_LESS_THAN = new RowLessThanOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowLessThanOperator.class, "less", RowType.class, List.class, Block.class, Block.class);

    private RowLessThanOperator() {
        super(OperatorType.LESS_THAN);
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(type).bindTo(this.getMethodHandles((RowType)type, functionRegistry, OperatorType.LESS_THAN)), this.isDeterministic());
    }

    public static boolean less(RowType rowType, List<MethodHandle> lessThanFunctions, Block leftRow, Block rightRow) {
        int compareResult = RowLessThanOperator.compare(rowType, lessThanFunctions, leftRow, rightRow);
        return compareResult > 0;
    }
}

