/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SingleMapBlock;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.FunctionInvoker;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class MapSubscriptOperator
extends SqlOperator {
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, FunctionInvoker.class, MethodHandle.class, Type.class, Type.class, ConnectorSession.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, FunctionInvoker.class, MethodHandle.class, Type.class, Type.class, ConnectorSession.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, FunctionInvoker.class, MethodHandle.class, Type.class, Type.class, ConnectorSession.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, FunctionInvoker.class, MethodHandle.class, Type.class, Type.class, ConnectorSession.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", Boolean.TYPE, FunctionInvoker.class, MethodHandle.class, Type.class, Type.class, ConnectorSession.class, Block.class, Object.class);
    private final boolean legacyMissingKey;

    public MapSubscriptOperator(boolean legacyMissingKey) {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)"), (Object)TypeSignature.parseTypeSignature((String)"K")));
        this.legacyMissingKey = legacyMissingKey;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MethodHandle keyEqualsMethod = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType))).getMethodHandle();
        MethodHandle methodHandle = keyType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (keyType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (keyType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (keyType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = MethodHandles.insertArguments(methodHandle, 0, this.legacyMissingKey);
        FunctionInvoker functionInvoker = new FunctionInvoker(functionRegistry);
        methodHandle = methodHandle.bindTo(functionInvoker).bindTo(keyEqualsMethod).bindTo(keyType).bindTo(valueType);
        methodHandle = valueType.getJavaType() == Void.TYPE ? methodHandle.asType(methodHandle.type().changeReturnType(Void.TYPE)) : methodHandle.asType(methodHandle.type().changeReturnType(Primitives.wrap((Class)valueType.getJavaType())));
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, FunctionInvoker functionInvoker, MethodHandle keyEqualsMethod, Type keyType, Type valueType, ConnectorSession session, Block map, boolean key) {
        if (map instanceof SingleMapBlock) {
            SingleMapBlock mapBlock = (SingleMapBlock)map;
            int valuePosition = mapBlock.seekKeyExact(key);
            if (valuePosition == -1) {
                if (legacyMissingKey) {
                    return null;
                }
                throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
            }
            return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
        }
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getBoolean(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (legacyMissingKey) {
            return null;
        }
        throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, FunctionInvoker functionInvoker, MethodHandle keyEqualsMethod, Type keyType, Type valueType, ConnectorSession session, Block map, long key) {
        if (map instanceof SingleMapBlock) {
            SingleMapBlock mapBlock = (SingleMapBlock)map;
            int valuePosition = mapBlock.seekKeyExact(key);
            if (valuePosition == -1) {
                if (legacyMissingKey) {
                    return null;
                }
                throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
            }
            return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
        }
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getLong(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (legacyMissingKey) {
            return null;
        }
        throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, FunctionInvoker functionInvoker, MethodHandle keyEqualsMethod, Type keyType, Type valueType, ConnectorSession session, Block map, double key) {
        if (map instanceof SingleMapBlock) {
            SingleMapBlock mapBlock = (SingleMapBlock)map;
            int valuePosition = mapBlock.seekKeyExact(key);
            if (valuePosition == -1) {
                if (legacyMissingKey) {
                    return null;
                }
                throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
            }
            return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
        }
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getDouble(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (legacyMissingKey) {
            return null;
        }
        throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, FunctionInvoker functionInvoker, MethodHandle keyEqualsMethod, Type keyType, Type valueType, ConnectorSession session, Block map, Slice key) {
        if (map instanceof SingleMapBlock) {
            SingleMapBlock mapBlock = (SingleMapBlock)map;
            int valuePosition = mapBlock.seekKeyExact(key);
            if (valuePosition == -1) {
                if (legacyMissingKey) {
                    return null;
                }
                throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
            }
            return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
        }
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getSlice(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (legacyMissingKey) {
            return null;
        }
        throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
    }

    @UsedByGeneratedCode
    public static Object subscript(boolean legacyMissingKey, FunctionInvoker functionInvoker, MethodHandle keyEqualsMethod, Type keyType, Type valueType, ConnectorSession session, Block map, Object key) {
        if (map instanceof SingleMapBlock) {
            SingleMapBlock mapBlock = (SingleMapBlock)map;
            int valuePosition = mapBlock.seekKeyExact((Block)key);
            if (valuePosition == -1) {
                if (legacyMissingKey) {
                    return null;
                }
                throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
            }
            return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
        }
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invoke(keyType.getObject(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (legacyMissingKey) {
            return null;
        }
        throw MapSubscriptOperator.throwMissingKeyException(keyType, functionInvoker, key, session);
    }

    private static RuntimeException throwMissingKeyException(Type type, FunctionInvoker functionInvoker, Object value, ConnectorSession session) {
        String stringValue;
        try {
            stringValue = ((Slice)functionInvoker.invoke(Signatures.castSignature((Type)VarcharType.VARCHAR, type), session, value)).toStringUtf8();
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key not present in map");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Key not present in map: %s", stringValue));
    }
}

