/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapGenericEquality {
    private MapGenericEquality() {
    }

    public static Boolean genericEqual(MethodHandle keyEqualsFunction, MethodHandle keyHashcodeFunction, Type keyType, Block leftMapBlock, Block rightMapBlock, EqualityPredicate predicate) {
        LinkedHashMap<KeyWrapper, Integer> wrappedLeftMap = new LinkedHashMap<KeyWrapper, Integer>();
        for (int position = 0; position < leftMapBlock.getPositionCount(); position += 2) {
            wrappedLeftMap.put(new KeyWrapper(TypeUtils.readNativeValue((Type)keyType, (Block)leftMapBlock, (int)position), keyEqualsFunction, keyHashcodeFunction), position + 1);
        }
        LinkedHashMap<KeyWrapper, Integer> wrappedRightMap = new LinkedHashMap<KeyWrapper, Integer>();
        for (int position = 0; position < rightMapBlock.getPositionCount(); position += 2) {
            wrappedRightMap.put(new KeyWrapper(TypeUtils.readNativeValue((Type)keyType, (Block)rightMapBlock, (int)position), keyEqualsFunction, keyHashcodeFunction), position + 1);
        }
        if (wrappedLeftMap.size() != wrappedRightMap.size()) {
            return false;
        }
        for (Map.Entry entry : wrappedRightMap.entrySet()) {
            KeyWrapper key = (KeyWrapper)entry.getKey();
            Integer leftValuePosition = (Integer)wrappedLeftMap.get(key);
            if (leftValuePosition == null) {
                return false;
            }
            try {
                Boolean result = predicate.equals(leftValuePosition, (Integer)entry.getValue());
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return true;
    }

    private static final class KeyWrapper {
        private final Object key;
        private final MethodHandle hashCode;
        private final MethodHandle equals;

        public KeyWrapper(Object key, MethodHandle equals, MethodHandle hashCode) {
            this.key = key;
            this.equals = equals;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            try {
                return Long.hashCode(this.hashCode.invoke(this.key));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            try {
                return this.equals.invoke(this.key, other.key);
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    public static interface EqualityPredicate {
        public Boolean equals(int var1, int var2) throws Throwable;
    }
}

