/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.project.DictionaryAwarePageFilter;
import com.facebook.presto.operator.project.DictionaryAwarePageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessorOutput;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PageProcessor {
    static final int MAX_BATCH_SIZE = 8192;
    static final int MAX_PAGE_SIZE_IN_BYTES = 0x400000;
    static final int MIN_PAGE_SIZE_IN_BYTES = 0x100000;
    private final DictionarySourceIdFunction dictionarySourceIdFunction = new DictionarySourceIdFunction();
    private final Optional<PageFilter> filter;
    private final List<PageProjection> projections;
    private int projectBatchSize = 8192;

    public PageProcessor(Optional<PageFilter> filter, List<? extends PageProjection> projections) {
        this.filter = Objects.requireNonNull(filter, "filter is null").map(pageFilter -> {
            if (pageFilter.getInputChannels().size() == 1 && pageFilter.isDeterministic()) {
                return new DictionaryAwarePageFilter((PageFilter)pageFilter);
            }
            return pageFilter;
        });
        this.projections = (List)Objects.requireNonNull(projections, "projections is null").stream().map(projection -> {
            if (projection.getInputChannels().size() == 1 && projection.isDeterministic()) {
                return new DictionaryAwarePageProjection((PageProjection)projection, this.dictionarySourceIdFunction);
            }
            return projection;
        }).collect(ImmutableList.toImmutableList());
    }

    public PageProcessorOutput process(ConnectorSession session, Page page) {
        this.dictionarySourceIdFunction.reset();
        if (page.getPositionCount() == 0) {
            return PageProcessorOutput.EMPTY_PAGE_PROCESSOR_OUTPUT;
        }
        if (this.filter.isPresent()) {
            SelectedPositions selectedPositions = this.filter.get().filter(session, this.filter.get().getInputChannels().getInputChannels(page));
            if (selectedPositions.isEmpty()) {
                return PageProcessorOutput.EMPTY_PAGE_PROCESSOR_OUTPUT;
            }
            if (this.projections.isEmpty()) {
                return new PageProcessorOutput(page.getRetainedSizeInBytes(), (Iterator<Page>)Iterators.singletonIterator((Object)new Page(selectedPositions.size(), new Block[0])));
            }
            if (selectedPositions.size() != page.getPositionCount()) {
                return new PageProcessorOutput(page.getRetainedSizeInBytes(), (Iterator<Page>)((Object)new PositionsPageProcessorIterator(session, page, selectedPositions)));
            }
        }
        return new PageProcessorOutput(page.getRetainedSizeInBytes(), (Iterator<Page>)((Object)new PositionsPageProcessorIterator(session, page, SelectedPositions.positionsRange(0, page.getPositionCount()))));
    }

    @NotThreadSafe
    private static class DictionarySourceIdFunction
    implements Function<DictionaryBlock, DictionaryId> {
        private final Map<DictionaryId, DictionaryId> dictionarySourceIds = new HashMap<DictionaryId, DictionaryId>();

        private DictionarySourceIdFunction() {
        }

        @Override
        public DictionaryId apply(DictionaryBlock block) {
            return this.dictionarySourceIds.computeIfAbsent(block.getDictionarySourceId(), ignored -> DictionaryId.randomDictionaryId());
        }

        public void reset() {
            this.dictionarySourceIds.clear();
        }
    }

    private class PositionsPageProcessorIterator
    extends AbstractIterator<Page> {
        private final ConnectorSession session;
        private final Page page;
        private SelectedPositions selectedPositions;
        private final Block[] previouslyComputedResults;

        public PositionsPageProcessorIterator(ConnectorSession session, Page page, SelectedPositions selectedPositions) {
            this.session = session;
            this.page = page;
            this.selectedPositions = selectedPositions;
            this.previouslyComputedResults = new Block[PageProcessor.this.projections.size()];
        }

        protected Page computeNext() {
            Optional<Page> result;
            int batchSize;
            while (true) {
                if (this.selectedPositions.isEmpty()) {
                    return (Page)this.endOfData();
                }
                batchSize = Math.min(this.selectedPositions.size(), PageProcessor.this.projectBatchSize);
                result = this.processBatch(batchSize);
                if (result.isPresent()) break;
                Verify.verify((batchSize > 1 ? 1 : 0) != 0);
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize / 2;
            }
            Page page = result.get();
            long pageSize = page.getSizeInBytes();
            if (page.getPositionCount() > 1 && pageSize > 0x400000L) {
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize / 2;
            }
            if (pageSize < 0x100000L && PageProcessor.this.projectBatchSize < 8192) {
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize * 2;
            }
            this.selectedPositions = this.selectedPositions.subRange(batchSize, this.selectedPositions.size());
            for (int i = 0; i < this.previouslyComputedResults.length; ++i) {
                this.previouslyComputedResults[i] = this.previouslyComputedResults[i] != null && this.previouslyComputedResults[i].getPositionCount() > batchSize ? this.previouslyComputedResults[i].getRegion(batchSize, this.previouslyComputedResults[i].getPositionCount() - batchSize) : null;
            }
            return page;
        }

        private Optional<Page> processBatch(int batchSize) {
            Block[] blocks = new Block[PageProcessor.this.projections.size()];
            int pageSize = 0;
            SelectedPositions positionsBatch = this.selectedPositions.subRange(0, batchSize);
            for (int i = 0; i < PageProcessor.this.projections.size(); ++i) {
                if (positionsBatch.size() > 1 && pageSize > 0x400000) {
                    return Optional.empty();
                }
                PageProjection projection = (PageProjection)PageProcessor.this.projections.get(i);
                if (this.previouslyComputedResults[i] != null && this.previouslyComputedResults[i].getPositionCount() > batchSize) {
                    blocks[i] = this.previouslyComputedResults[i].getRegion(0, batchSize);
                } else {
                    this.previouslyComputedResults[i] = projection.project(this.session, projection.getInputChannels().getInputChannels(this.page), positionsBatch);
                    blocks[i] = this.previouslyComputedResults[i];
                }
                pageSize += blocks[i].getSizeInBytes();
            }
            return Optional.of(new Page(positionsBatch.size(), blocks));
        }
    }
}

