/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.primitives.Ints;
import java.util.List;

public class InputPageProjection
implements PageProjection {
    private final Type type;
    private final InputChannels inputChannels;

    public InputPageProjection(int inputChannel, Type type) {
        this.type = type;
        this.inputChannels = new InputChannels(inputChannel);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Block project(ConnectorSession session, Page page, SelectedPositions selectedPositions) {
        Block block = page.getBlock(0);
        if (selectedPositions.isList()) {
            List positionList = Ints.asList((int[])selectedPositions.getPositions()).subList(selectedPositions.getOffset(), selectedPositions.getOffset() + selectedPositions.size());
            return block.copyPositions(positionList);
        }
        return block.getRegion(selectedPositions.getOffset(), selectedPositions.size());
    }
}

