/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.operator.exchange.PageReference;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

class PartitioningExchanger
implements Consumer<Page> {
    private final List<Consumer<PageReference>> buffers;
    private final LongConsumer memoryTracker;
    private final LocalPartitionGenerator partitionGenerator;
    private final IntList[] partitionAssignments;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LongConsumer memoryTracker, List<? extends Type> types, List<Integer> partitionChannels, Optional<Integer> hashChannel) {
        HashGenerator hashGenerator;
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryTracker = Objects.requireNonNull(memoryTracker, "memoryTracker is null");
        if (hashChannel.isPresent()) {
            hashGenerator = new PrecomputedHashGenerator(hashChannel.get());
        } else {
            List partitionChannelTypes = (List)partitionChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            hashGenerator = new InterpretedHashGenerator(partitionChannelTypes, Ints.toArray(partitionChannels));
        }
        this.partitionGenerator = new LocalPartitionGenerator(hashGenerator, this.buffers.size());
        this.partitionAssignments = new IntList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public synchronized void accept(Page page) {
        for (IntList partitionAssignment : this.partitionAssignments) {
            partitionAssignment.clear();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int partition = this.partitionGenerator.getPartition(position, page);
            this.partitionAssignments[partition].add(position);
        }
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length];
        for (int partition = 0; partition < this.buffers.size(); ++partition) {
            IntList positions = this.partitionAssignments[partition];
            if (positions.isEmpty()) continue;
            for (int i = 0; i < sourceBlocks.length; ++i) {
                outputBlocks[i] = sourceBlocks[i].copyPositions((List)positions);
            }
            Page pageSplit = new Page(positions.size(), outputBlocks);
            this.memoryTracker.accept(pageSplit.getRetainedSizeInBytes());
            this.buffers.get(partition).accept(new PageReference(pageSplit, 1, () -> this.memoryTracker.accept(-pageSplit.getRetainedSizeInBytes())));
        }
    }
}

