/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.builder;

import com.facebook.presto.memory.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.MergeHashSort;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.MergingHashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class SpillableHashAggregationBuilder
implements HashAggregationBuilder {
    private InMemoryHashAggregationBuilder hashAggregationBuilder;
    private final SpillerFactory spillerFactory;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private final long memorySizeBeforeSpill;
    private final long memoryLimitForMergeWithMemory;
    private Optional<Spiller> spiller = Optional.empty();
    private Optional<MergingHashAggregationBuilder> merger = Optional.empty();
    private Optional<MergeHashSort> mergeHashSort = Optional.empty();
    private ListenableFuture<?> spillInProgress = Futures.immediateFuture(null);
    private final LocalMemoryContext aggregationMemoryContext;
    private final LocalMemoryContext spillMemoryContext;
    private final JoinCompiler joinCompiler;
    private long hashCollisions;
    private double expectedHashCollisions;

    public SpillableHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, DataSize memoryLimitBeforeSpill, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler) {
        this.accumulatorFactories = accumulatorFactories;
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.groupByTypes = groupByTypes;
        this.groupByChannels = groupByChannels;
        this.hashChannel = hashChannel;
        this.operatorContext = operatorContext;
        this.memorySizeBeforeSpill = memoryLimitBeforeSpill.toBytes();
        this.memoryLimitForMergeWithMemory = memoryLimitForMergeWithMemory.toBytes();
        this.spillerFactory = spillerFactory;
        this.joinCompiler = joinCompiler;
        AbstractAggregatedMemoryContext systemMemoryContext = operatorContext.getSystemMemoryContext();
        this.aggregationMemoryContext = systemMemoryContext.newLocalMemoryContext();
        this.spillMemoryContext = systemMemoryContext.newLocalMemoryContext();
        this.rebuildHashAggregationBuilder();
    }

    @Override
    public void processPage(Page page) {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        this.hashAggregationBuilder.processPage(page);
        if (this.shouldSpill(this.getSizeInMemory())) {
            this.spillToDisk();
        }
    }

    @Override
    public void updateMemory() {
        this.aggregationMemoryContext.setBytes(this.getSizeInMemory());
        if (this.spillInProgress.isDone()) {
            this.spillMemoryContext.setBytes(0L);
        }
    }

    public long getSizeInMemory() {
        return this.hashAggregationBuilder.getSizeInMemory() + this.hashAggregationBuilder.getGroupIdsSortingSize();
    }

    @Override
    public void recordHashCollisions(HashCollisionsCounter hashCollisionsCounter) {
        hashCollisionsCounter.recordHashCollision(this.hashCollisions, this.expectedHashCollisions);
        this.hashCollisions = 0L;
        this.expectedHashCollisions = 0.0;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.spillInProgress;
    }

    private boolean hasPreviousSpillCompletedSuccessfully() {
        if (this.isBlocked().isDone()) {
            MoreFutures.getFutureValue(this.spillInProgress);
            return true;
        }
        return false;
    }

    private boolean shouldSpill(long memorySize) {
        return this.memorySizeBeforeSpill > 0L && memorySize > this.memorySizeBeforeSpill;
    }

    private boolean shouldMergeWithMemory(long memorySize) {
        return memorySize < this.memoryLimitForMergeWithMemory;
    }

    @Override
    public Iterator<Page> buildResult() {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        if (!this.spiller.isPresent()) {
            return this.hashAggregationBuilder.buildResult();
        }
        try {
            if (this.shouldMergeWithMemory(this.getSizeInMemory())) {
                return this.mergeFromDiskAndMemory();
            }
            this.spillToDisk().get();
            return this.mergeFromDisk();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.merger.isPresent()) {
            this.merger.get().close();
        }
        if (this.spiller.isPresent()) {
            this.spiller.get().close();
        }
        if (this.mergeHashSort.isPresent()) {
            this.mergeHashSort.get().close();
        }
    }

    private ListenableFuture<?> spillToDisk() {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        this.hashAggregationBuilder.setOutputPartial();
        if (!this.spiller.isPresent()) {
            this.spiller = Optional.of(this.spillerFactory.create(this.hashAggregationBuilder.buildTypes(), this.operatorContext.getSpillContext(), this.operatorContext.getSystemMemoryContext().newAggregatedMemoryContext()));
        }
        long spillMemoryUsage = this.getSizeInMemory();
        this.spillInProgress = this.spiller.get().spill(this.hashAggregationBuilder.buildHashSortedResult());
        this.rebuildHashAggregationBuilder();
        this.aggregationMemoryContext.setBytes(this.getSizeInMemory());
        this.spillMemoryContext.setBytes(spillMemoryUsage);
        return this.spillInProgress;
    }

    private Iterator<Page> mergeFromDiskAndMemory() {
        Preconditions.checkState((boolean)this.spiller.isPresent());
        this.hashAggregationBuilder.setOutputPartial();
        this.mergeHashSort = Optional.of(new MergeHashSort(this.operatorContext.getSystemMemoryContext().newAggregatedMemoryContext()));
        Iterator<Page> mergedSpilledPages = this.mergeHashSort.get().merge(this.groupByTypes, this.hashAggregationBuilder.buildIntermediateTypes(), (List<Iterator<Page>>)ImmutableList.builder().addAll(this.spiller.get().getSpills()).add(this.hashAggregationBuilder.buildHashSortedResult()).build());
        return this.mergeSortedPages(mergedSpilledPages, Math.max(this.memorySizeBeforeSpill - this.memoryLimitForMergeWithMemory, 1L));
    }

    private Iterator<Page> mergeFromDisk() {
        Preconditions.checkState((boolean)this.spiller.isPresent());
        this.mergeHashSort = Optional.of(new MergeHashSort(this.operatorContext.getSystemMemoryContext().newAggregatedMemoryContext()));
        Iterator<Page> mergedSpilledPages = this.mergeHashSort.get().merge(this.groupByTypes, this.hashAggregationBuilder.buildIntermediateTypes(), this.spiller.get().getSpills());
        return this.mergeSortedPages(mergedSpilledPages, this.memorySizeBeforeSpill);
    }

    private Iterator<Page> mergeSortedPages(Iterator<Page> sortedPages, long memorySizeBeforeSpill) {
        this.merger = Optional.of(new MergingHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.hashChannel, this.operatorContext, sortedPages, this.operatorContext.getSystemMemoryContext().newLocalMemoryContext(), memorySizeBeforeSpill, this.hashAggregationBuilder.getKeyChannels(), this.joinCompiler));
        return this.merger.get().buildResult();
    }

    private void rebuildHashAggregationBuilder() {
        if (this.hashAggregationBuilder != null) {
            this.hashCollisions += this.hashAggregationBuilder.getHashCollisions();
            this.expectedHashCollisions += this.hashAggregationBuilder.getExpectedHashCollisions();
        }
        this.hashAggregationBuilder = new InMemoryHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, DataSize.succinctBytes((long)0L), this.joinCompiler);
    }
}

