/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class MultiKeyValuePairs {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MultiKeyValuePairs.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private final BlockBuilder keyBlockBuilder;
    private final Type keyType;
    private final BlockBuilder valueBlockBuilder;
    private final Type valueType;
    private final RowType serializedRowType;

    public MultiKeyValuePairs(Type keyType, Type valueType) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.keyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(keyType, 16));
        this.valueBlockBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(valueType, 16));
        this.serializedRowType = new RowType((List<Type>)ImmutableList.of((Object)keyType, (Object)valueType), Optional.empty());
    }

    public MultiKeyValuePairs(Block serialized, Type keyType, Type valueType) {
        this(keyType, valueType);
        this.deserialize(Objects.requireNonNull(serialized, "serialized is null"));
    }

    public Block getKeys() {
        return this.keyBlockBuilder.build();
    }

    public Block getValues() {
        return this.valueBlockBuilder.build();
    }

    private void deserialize(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Block entryBlock = (Block)block.getObject(i, Block.class);
            this.add(entryBlock, entryBlock, 0, 1);
        }
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
        for (int i = 0; i < this.keyBlockBuilder.getPositionCount(); ++i) {
            BlockBuilder rowBlockBuilder = arrayBlockBuilder.beginBlockEntry();
            this.keyType.appendTo((Block)this.keyBlockBuilder, i, rowBlockBuilder);
            this.valueType.appendTo((Block)this.valueBlockBuilder, i, rowBlockBuilder);
            arrayBlockBuilder.closeEntry();
        }
        out.closeEntry();
    }

    public Block toMultimapNativeEncoding() {
        Block keys = this.keyBlockBuilder.build();
        Block values = this.valueBlockBuilder.build();
        BlockBuilder distinctKeyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), keys.getPositionCount(), TypeUtils.expectedValueSize(this.keyType, 16));
        ObjectBigArray valueArrayBlockBuilders = new ObjectBigArray();
        valueArrayBlockBuilders.ensureCapacity((long)keys.getPositionCount());
        TypedSet keySet = new TypedSet(this.keyType, keys.getPositionCount());
        for (int keyValueIndex = 0; keyValueIndex < keys.getPositionCount(); ++keyValueIndex) {
            if (!keySet.contains(keys, keyValueIndex)) {
                keySet.add(keys, keyValueIndex);
                this.keyType.appendTo(keys, keyValueIndex, distinctKeyBlockBuilder);
                BlockBuilder valueArrayBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(this.valueType, 16));
                valueArrayBlockBuilders.set((long)keySet.positionOf(keys, keyValueIndex), (Object)valueArrayBuilder);
            }
            this.valueType.appendTo(values, keyValueIndex, (BlockBuilder)valueArrayBlockBuilders.get((long)keySet.positionOf(keys, keyValueIndex)));
        }
        Block distinctKeys = distinctKeyBlockBuilder.build();
        ArrayType valueArrayType = new ArrayType(this.valueType);
        InterleavedBlockBuilder multimapBlockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)this.keyType, (Object)((Object)valueArrayType)), new BlockBuilderStatus(), distinctKeyBlockBuilder.getPositionCount());
        for (int i = 0; i < distinctKeys.getPositionCount(); ++i) {
            this.keyType.appendTo(distinctKeys, i, (BlockBuilder)multimapBlockBuilder);
            valueArrayType.writeObject((BlockBuilder)multimapBlockBuilder, ((BlockBuilder)valueArrayBlockBuilders.get((long)i)).build());
        }
        return multimapBlockBuilder.build();
    }

    public long estimatedInMemorySize() {
        long size = INSTANCE_SIZE;
        size += (long)this.keyBlockBuilder.getRetainedSizeInBytes();
        return size += (long)this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    public void add(Block key, Block value, int keyPosition, int valuePosition) {
        this.keyType.appendTo(key, keyPosition, this.keyBlockBuilder);
        if (value.isNull(valuePosition)) {
            this.valueBlockBuilder.appendNull();
        } else {
            this.valueType.appendTo(value, valuePosition, this.valueBlockBuilder);
        }
    }
}

