/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

@AggregationFunction(value="bitwise_or_agg")
public class BitwiseOrAggregation {
    private BitwiseOrAggregation() {
    }

    @InputFunction
    public static void bitOr(@AggregationState NullableLongState state, @SqlType(value="bigint") long value) {
        if (state.isNull()) {
            state.setLong(value);
        } else {
            state.setLong(state.getLong() | value);
        }
        state.setNull(false);
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        if (state.isNull()) {
            state.setNull(otherState.isNull());
            state.setLong(otherState.getLong());
        } else if (!otherState.isNull()) {
            state.setLong(state.getLong() | otherState.getLong());
        }
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

