/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InternalJoinFilterFunction;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StandardJoinFilterFunction
implements JoinFilterFunction {
    private static final Block[] EMPTY_BLOCK_ARRAY = new Block[0];
    private final InternalJoinFilterFunction filterFunction;
    private final LongArrayList addresses;
    private final List<Block[]> pages;
    private final Optional<Integer> sortChannel;

    public StandardJoinFilterFunction(InternalJoinFilterFunction filterFunction, LongArrayList addresses, List<List<Block>> channels, Optional<Integer> sortChannel) {
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction can not be null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.sortChannel = Objects.requireNonNull(sortChannel, "sortChannel is null");
        Objects.requireNonNull(channels, "channels can not be null");
        ImmutableList.Builder pagesBuilder = ImmutableList.builder();
        if (!channels.isEmpty()) {
            int pagesCount = channels.get(0).size();
            for (int pageIndex = 0; pageIndex < pagesCount; ++pageIndex) {
                Block[] blocks = new Block[channels.size()];
                for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
                    blocks[channelIndex] = channels.get(channelIndex).get(pageIndex);
                }
                pagesBuilder.add((Object)blocks);
            }
        }
        this.pages = pagesBuilder.build();
    }

    @Override
    public boolean filter(int leftAddress, int rightPosition, Page rightPage) {
        long pageAddress = this.addresses.getLong(leftAddress);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.filterFunction.filter(blockPosition, this.getLeftBlocks(blockIndex), rightPosition, rightPage.getBlocks());
    }

    @Override
    public Optional<Integer> getSortChannel() {
        return this.sortChannel;
    }

    private Block[] getLeftBlocks(int leftBlockIndex) {
        if (this.pages.isEmpty()) {
            return EMPTY_BLOCK_ARRAY;
        }
        return this.pages.get(leftBlockIndex);
    }
}

