/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ArrayPositionLinks;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class SortedPositionLinks
implements PositionLinks {
    private final PositionLinks positionLinks;
    private final int[][] sortedPositionLinks;
    private final JoinFilterFunction lessThanFunction;
    private final long sizeInBytes;

    private SortedPositionLinks(PositionLinks positionLinks, int[][] sortedPositionLinks, JoinFilterFunction lessThanFunction) {
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null");
        this.sortedPositionLinks = Objects.requireNonNull(sortedPositionLinks, "sortedPositionLinks is null");
        this.lessThanFunction = Objects.requireNonNull(lessThanFunction, "lessThanFunction is null");
        this.sizeInBytes = positionLinks.getSizeInBytes() + SizeOf.sizeOf((Object[])sortedPositionLinks);
    }

    public static Builder builder(int size, IntComparator comparator) {
        return new Builder(size, comparator);
    }

    @Override
    public int next(int position, int probePosition, Page allProbeChannelsPage) {
        int nextPosition = this.positionLinks.next(position, probePosition, allProbeChannelsPage);
        if (nextPosition < 0) {
            return -1;
        }
        if (this.applyLessThanFunction(nextPosition, probePosition, allProbeChannelsPage)) {
            return nextPosition;
        }
        return -1;
    }

    @Override
    public int start(int startingPosition, int probePosition, Page allProbeChannelsPage) {
        if (this.applyLessThanFunction(startingPosition, probePosition, allProbeChannelsPage)) {
            return startingPosition;
        }
        if (this.sortedPositionLinks[startingPosition] == null) {
            return -1;
        }
        int left = 0;
        int right = this.sortedPositionLinks[startingPosition].length - 1;
        int offset = this.lowerBound(startingPosition, left, right, probePosition, allProbeChannelsPage);
        if (offset < 0) {
            return -1;
        }
        if (!this.applyLessThanFunction(startingPosition, offset, probePosition, allProbeChannelsPage)) {
            return -1;
        }
        return this.sortedPositionLinks[startingPosition][offset];
    }

    private int lowerBound(int startingPosition, int first, int last, int probePosition, Page allProbeChannelsPage) {
        int count = last - first;
        while (count > 0) {
            int step = count / 2;
            int middle = first + step;
            if (!this.applyLessThanFunction(startingPosition, middle, probePosition, allProbeChannelsPage)) {
                first = ++middle;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private boolean applyLessThanFunction(int leftPosition, int leftOffset, int rightPosition, Page rightPage) {
        return this.applyLessThanFunction(this.sortedPositionLinks[leftPosition][leftOffset], rightPosition, rightPage);
    }

    private boolean applyLessThanFunction(long leftPosition, int rightPosition, Page rightPage) {
        return this.lessThanFunction.filter((int)leftPosition, rightPosition, rightPage);
    }

    public static class Builder
    implements PositionLinks.Builder {
        private final Int2ObjectMap<IntArrayList> positionLinks;
        private final int size;
        private final IntComparator comparator;

        public Builder(int size, IntComparator comparator) {
            this.comparator = comparator;
            this.size = size;
            this.positionLinks = new Int2ObjectOpenHashMap();
        }

        @Override
        public int link(int from, int to) {
            if (this.comparator.compare(from, to) > 0) {
                List links = (List)this.positionLinks.computeIfAbsent((Object)to, key -> new IntArrayList());
                links.add(from);
                return to;
            }
            IntArrayList links = (IntArrayList)this.positionLinks.remove(to);
            if (links == null) {
                links = new IntArrayList();
            }
            links.add(to);
            Preconditions.checkState((this.positionLinks.putIfAbsent((Object)from, (Object)links) == null ? 1 : 0) != 0, (Object)"sorted links is corrupted");
            return from;
        }

        @Override
        public Function<Optional<JoinFilterFunction>, PositionLinks> build() {
            ArrayPositionLinks.Builder builder = ArrayPositionLinks.builder(this.size);
            int[][] sortedPositionLinks = new int[this.size][];
            for (Int2ObjectMap.Entry entry : this.positionLinks.int2ObjectEntrySet()) {
                int i;
                int key = entry.getIntKey();
                IntArrayList positions = (IntArrayList)entry.getValue();
                positions.sort((Comparator)this.comparator);
                sortedPositionLinks[key] = new int[positions.size()];
                for (i = 0; i < positions.size(); ++i) {
                    sortedPositionLinks[key][i] = positions.get(i);
                }
                for (i = positions.size() - 2; i >= 0; --i) {
                    builder.link(positions.get(i), positions.get(i + 1));
                }
                if (positions.isEmpty()) continue;
                builder.link(key, positions.get(0));
            }
            return lessThanFunction -> {
                Preconditions.checkState((boolean)lessThanFunction.isPresent(), (Object)"Using SortedPositionLinks without lessThanFunction");
                return new SortedPositionLinks(builder.build().apply((Optional<JoinFilterFunction>)lessThanFunction), sortedPositionLinks, (JoinFilterFunction)lessThanFunction.get());
            };
        }
    }
}

