/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.MapType;
import java.util.Objects;
import javax.annotation.Nullable;

public class MapUnnester
implements Unnester {
    private final Type keyType;
    private final Type valueType;
    private Block block;
    private final int channelCount;
    private int position;
    private int positionCount;

    public MapUnnester(MapType mapType, @Nullable Block mapBlock) {
        this.channelCount = 2;
        Objects.requireNonNull(mapType, "mapType is null");
        this.keyType = mapType.getKeyType();
        this.valueType = mapType.getValueType();
        this.block = mapBlock;
        this.positionCount = mapBlock == null ? 0 : mapBlock.getPositionCount();
    }

    protected void appendTo(PageBuilder pageBuilder, int outputChannelOffset) {
        BlockBuilder keyBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
        BlockBuilder valueBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset + 1);
        this.keyType.appendTo(this.block, this.position++, keyBlockBuilder);
        this.valueType.appendTo(this.block, this.position++, valueBlockBuilder);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.positionCount;
    }

    @Override
    public final int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public final void appendNext(PageBuilder pageBuilder, int outputChannelOffset) {
        this.appendTo(pageBuilder, outputChannelOffset);
    }

    @Override
    public void setBlock(@Nullable Block mapBlock) {
        this.block = mapBlock;
        this.position = 0;
        this.positionCount = mapBlock == null ? 0 : mapBlock.getPositionCount();
    }
}

