/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.ArrayPositionLinks;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.JoinHash;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.PagesHash;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.operator.SortedPositionLinks;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class JoinHashSupplier
implements LookupSourceSupplier {
    private final Session session;
    private final PagesHash pagesHash;
    private final LongArrayList addresses;
    private final List<List<Block>> channels;
    private final Function<Optional<JoinFilterFunction>, PositionLinks> positionLinks;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;

    public JoinHashSupplier(Session session, PagesHashStrategy pagesHashStrategy, LongArrayList addresses, List<List<Block>> channels, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
        Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        PositionLinks.Builder positionLinksBuilder = filterFunctionFactory.isPresent() && filterFunctionFactory.get().getSortChannel().isPresent() && SystemSessionProperties.isFastInequalityJoin(session) ? SortedPositionLinks.builder(addresses.size(), new PositionComparator(pagesHashStrategy, addresses)) : ArrayPositionLinks.builder(addresses.size());
        this.pagesHash = new PagesHash(addresses, pagesHashStrategy, positionLinksBuilder);
        this.positionLinks = positionLinksBuilder.build();
    }

    @Override
    public long getHashCollisions() {
        return this.pagesHash.getHashCollisions();
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.pagesHash.getExpectedHashCollisions();
    }

    @Override
    public JoinHash get() {
        Optional<JoinFilterFunction> filterFunction = this.filterFunctionFactory.map(factory -> factory.create(this.session.toConnectorSession(), this.addresses, this.channels));
        return new JoinHash(this.pagesHash, filterFunction, this.positionLinks.apply(filterFunction));
    }

    public static class PositionComparator
    implements IntComparator {
        private final PagesHashStrategy pagesHashStrategy;
        private final LongArrayList addresses;

        public PositionComparator(PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
            this.pagesHashStrategy = pagesHashStrategy;
            this.addresses = addresses;
        }

        public int compare(int leftPosition, int rightPosition) {
            long leftPageAddress = this.addresses.getLong(leftPosition);
            int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
            int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
            long rightPageAddress = this.addresses.getLong(rightPosition);
            int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
            int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
            return this.pagesHashStrategy.compare(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
        }

        public int compare(Integer leftPosition, Integer rightPosition) {
            return this.compare((int)leftPosition, (int)rightPosition);
        }
    }
}

