/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesHash;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class JoinHash
implements LookupSource {
    private final PagesHash pagesHash;
    @Nullable
    private final JoinFilterFunction filterFunction;
    private final PositionLinks positionLinks;

    public JoinHash(PagesHash pagesHash, Optional<JoinFilterFunction> filterFunction, PositionLinks positionLinks) {
        this.pagesHash = Objects.requireNonNull(pagesHash, "pagesHash is null");
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction can not be null").orElse(null);
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null");
    }

    @Override
    public final int getChannelCount() {
        return this.pagesHash.getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        return this.pagesHash.getPositionCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.pagesHash.getInMemorySizeInBytes() + this.positionLinks.getSizeInBytes();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage, allChannelsPage);
        return this.startJoinPosition(addressIndex, position, allChannelsPage);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage, allChannelsPage, rawHash);
        return this.startJoinPosition(addressIndex, position, allChannelsPage);
    }

    private long startJoinPosition(int currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        if (currentJoinPosition == -1) {
            return -1L;
        }
        return this.positionLinks.start(currentJoinPosition, probePosition, allProbeChannelsPage);
    }

    @Override
    public final long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.positionLinks.next(Math.toIntExact(currentJoinPosition), probePosition, allProbeChannelsPage);
    }

    @Override
    public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.filterFunction == null || this.filterFunction.filter(Math.toIntExact(currentJoinPosition), probePosition, allProbeChannelsPage);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.pagesHash.appendTo(Math.toIntExact(position), pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }
}

