/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Mergeable;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ExchangeClientStatus
implements Mergeable<ExchangeClientStatus>,
OperatorInfo {
    private final long bufferedBytes;
    private final long maxBufferedBytes;
    private final long averageBytesPerRequest;
    private final long successfulRequestsCount;
    private final int bufferedPages;
    private final boolean noMoreLocations;
    private final List<PageBufferClientStatus> pageBufferClientStatuses;

    @JsonCreator
    public ExchangeClientStatus(@JsonProperty(value="bufferedBytes") long bufferedBytes, @JsonProperty(value="maxBufferedBytes") long maxBufferedBytes, @JsonProperty(value="averageBytesPerRequest") long averageBytesPerRequest, @JsonProperty(value="successfulRequestsCount") long successFullRequestsCount, @JsonProperty(value="bufferedPages") int bufferedPages, @JsonProperty(value="noMoreLocations") boolean noMoreLocations, @JsonProperty(value="pageBufferClientStatuses") List<PageBufferClientStatus> pageBufferClientStatuses) {
        this.bufferedBytes = bufferedBytes;
        this.maxBufferedBytes = maxBufferedBytes;
        this.averageBytesPerRequest = averageBytesPerRequest;
        this.successfulRequestsCount = successFullRequestsCount;
        this.bufferedPages = bufferedPages;
        this.noMoreLocations = noMoreLocations;
        this.pageBufferClientStatuses = ImmutableList.copyOf((Collection)Objects.requireNonNull(pageBufferClientStatuses, "pageBufferClientStatuses is null"));
    }

    @JsonProperty
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    @JsonProperty
    public long getMaxBufferedBytes() {
        return this.maxBufferedBytes;
    }

    @JsonProperty
    public long getAverageBytesPerRequest() {
        return this.averageBytesPerRequest;
    }

    @JsonProperty
    public long getSuccessfulRequestsCount() {
        return this.successfulRequestsCount;
    }

    @JsonProperty
    public int getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    public boolean isNoMoreLocations() {
        return this.noMoreLocations;
    }

    @JsonProperty
    public List<PageBufferClientStatus> getPageBufferClientStatuses() {
        return this.pageBufferClientStatuses;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bufferBytes", this.bufferedBytes).add("maxBufferBytes", this.maxBufferedBytes).add("averageBytesPerRequest", this.averageBytesPerRequest).add("successfulRequestsCount", this.successfulRequestsCount).add("bufferedPages", this.bufferedPages).add("noMoreLocations", this.noMoreLocations).add("pageBufferClientStatuses", this.pageBufferClientStatuses).toString();
    }

    @Override
    public ExchangeClientStatus mergeWith(ExchangeClientStatus other) {
        return new ExchangeClientStatus((this.bufferedBytes + other.bufferedBytes) / 2L, Math.max(this.maxBufferedBytes, other.maxBufferedBytes), ExchangeClientStatus.mergeAvgs(this.averageBytesPerRequest, this.successfulRequestsCount, other.averageBytesPerRequest, other.successfulRequestsCount), this.successfulRequestsCount + other.successfulRequestsCount, this.bufferedPages + other.bufferedPages, this.noMoreLocations && other.noMoreLocations, (List<PageBufferClientStatus>)ImmutableList.of());
    }

    private static long mergeAvgs(long value1, long count1, long value2, long count2) {
        if (count1 == 0L) {
            return value2;
        }
        if (count2 == 0L) {
            return value1;
        }
        return value1 * count1 / (count1 + count2) + value2 * count2 / (count1 + count2);
    }
}

