/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class AssignUniqueIdOperator
implements Operator {
    private static final long ROW_IDS_PER_REQUEST = 0x100000L;
    private static final long MAX_ROW_ID = 0x10000000000L;
    private final OperatorContext operatorContext;
    private boolean finishing;
    private final AtomicLong rowIdPool;
    private final List<Type> types;
    private final long uniqueValueMask;
    private final int inputPageChannelCount;
    private Page inputPage;
    private long rowIdCounter;
    private long maxRowIdCounterValue;

    public AssignUniqueIdOperator(OperatorContext operatorContext, List<Type> types, AtomicLong rowIdPool) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf(types);
        this.rowIdPool = Objects.requireNonNull(rowIdPool, "rowIdPool is null");
        TaskId fullTaskId = operatorContext.getDriverContext().getTaskId();
        this.uniqueValueMask = (long)fullTaskId.getStageId().getId() << 54 | (long)fullTaskId.getId() << 40;
        this.inputPageChannelCount = types.size() - 1;
        this.requestValues();
    }

    private void requestValues() {
        this.rowIdCounter = this.rowIdPool.getAndAdd(0x100000L);
        this.maxRowIdCounterValue = Math.min(this.rowIdCounter + 0x100000L, 0x10000000000L);
        Preconditions.checkState((this.rowIdCounter < 0x10000000000L ? 1 : 0) != 0, (String)"Unique row id exceeds a limit: %s", (long)0x10000000000L);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.inputPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.inputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.inputPage == null ? 1 : 0) != 0);
        this.inputPage = page;
    }

    @Override
    public Page getOutput() {
        if (this.inputPage == null) {
            return null;
        }
        Page outputPage = this.processPage();
        this.inputPage = null;
        return outputPage;
    }

    private Page processPage() {
        Block[] outputBlocks = new Block[this.inputPageChannelCount + 1];
        for (int i = 0; i < this.inputPageChannelCount; ++i) {
            outputBlocks[i] = this.inputPage.getBlock(i);
        }
        outputBlocks[this.inputPageChannelCount] = this.generateIdColumn();
        return new Page(this.inputPage.getPositionCount(), outputBlocks);
    }

    private Block generateIdColumn() {
        BlockBuilder block = BigintType.BIGINT.createFixedSizeBlockBuilder(this.inputPage.getPositionCount());
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long rowId;
            if (this.rowIdCounter >= this.maxRowIdCounterValue) {
                this.requestValues();
            }
            ++this.rowIdCounter;
            Verify.verify(((rowId & this.uniqueValueMask) == 0L ? 1 : 0) != 0, (String)"RowId and uniqueValue mask overlaps", (Object[])new Object[0]);
            BigintType.BIGINT.writeLong(block, this.uniqueValueMask | rowId);
        }
        return block.build();
    }

    public static class AssignUniqueIdOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> types;
        private boolean closed;
        private final AtomicLong valuePool = new AtomicLong();

        public AssignUniqueIdOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.types = ImmutableList.copyOf(types);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, AssignUniqueIdOperator.class.getSimpleName());
            return new AssignUniqueIdOperator(operatorContext, this.types, this.valuePool);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new AssignUniqueIdOperatorFactory(this.operatorId, this.planNodeId, this.types);
        }
    }
}

