/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.spi.Page;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class ArrayPositionLinks
implements PositionLinks {
    private final int[] positionLinks;

    private ArrayPositionLinks(int[] positionLinks) {
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null");
    }

    public static Builder builder(int size) {
        return new Builder(size);
    }

    @Override
    public int start(int position, int probePosition, Page allProbeChannelsPage) {
        return position;
    }

    @Override
    public int next(int position, int probePosition, Page allProbeChannelsPage) {
        return this.positionLinks[position];
    }

    @Override
    public long getSizeInBytes() {
        return SizeOf.sizeOf((int[])this.positionLinks);
    }

    public static class Builder
    implements PositionLinks.Builder {
        private final int[] positionLinks;

        private Builder(int size) {
            this.positionLinks = new int[size];
            Arrays.fill(this.positionLinks, -1);
        }

        @Override
        public int link(int left, int right) {
            this.positionLinks[left] = right;
            return left;
        }

        @Override
        public Function<Optional<JoinFilterFunction>, PositionLinks> build() {
            return filterFunction -> new ArrayPositionLinks(this.positionLinks);
        }
    }
}

