/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public abstract class SqlAggregationFunction
implements SqlFunction {
    private final Signature signature;

    public static List<SqlAggregationFunction> createByAnnotations(Class<?> aggregationDefinition) {
        return (List)AggregationCompiler.generateBindableAggregationFunctions(aggregationDefinition).stream().map(x -> x).collect(ImmutableList.toImmutableList());
    }

    protected SqlAggregationFunction(Signature signature) {
        Objects.requireNonNull(signature, "signature is null");
        this.signature = signature;
    }

    protected SqlAggregationFunction(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, FunctionKind.AGGREGATE);
    }

    protected SqlAggregationFunction(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, FunctionKind kind) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        Preconditions.checkArgument((kind == FunctionKind.AGGREGATE ? 1 : 0) != 0, (Object)"kind must be an aggregate");
        this.signature = new Signature(name, kind, (List<TypeVariableConstraint>)ImmutableList.copyOf(typeVariableConstraints), (List<LongVariableConstraint>)ImmutableList.copyOf(longVariableConstraints), returnType, (List<TypeSignature>)ImmutableList.copyOf(argumentTypes), false);
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public abstract InternalAggregationFunction specialize(BoundVariables var1, int var2, TypeManager var3, FunctionRegistry var4);
}

