/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.NodeState;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RemoteNodeState {
    private static final Logger log = Logger.get(RemoteNodeState.class);
    private final HttpClient httpClient;
    private final URI stateInfoUri;
    private final AtomicReference<Optional<NodeState>> nodeState = new AtomicReference(Optional.empty());
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();

    public RemoteNodeState(HttpClient httpClient, URI stateInfoUri) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.stateInfoUri = Objects.requireNonNull(stateInfoUri, "stateInfoUri is null");
    }

    public Optional<NodeState> getNodeState() {
        return this.nodeState.get();
    }

    public synchronized void asyncRefresh() {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Node state update request to %s has not returned in %s", new Object[]{this.stateInfoUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > 1000L && this.future.get() == null) {
            Request request = Request.Builder.prepareGet().setUri(this.stateInfoUri).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).build();
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(NodeState.class)));
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<FullJsonResponseHandler.JsonResponse<NodeState>>(){

                public void onSuccess(@Nullable FullJsonResponseHandler.JsonResponse<NodeState> result) {
                    RemoteNodeState.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteNodeState.this.future.compareAndSet(responseFuture, null);
                    if (result != null) {
                        if (result.hasValue()) {
                            RemoteNodeState.this.nodeState.set(Optional.ofNullable(result.getValue()));
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching node state from %s returned status %d: %s", new Object[]{RemoteNodeState.this.stateInfoUri, result.getStatusCode(), result.getStatusMessage()});
                            return;
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    log.warn("Error fetching node state from %s: %s", new Object[]{RemoteNodeState.this.stateInfoUri, t.getMessage()});
                    RemoteNodeState.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteNodeState.this.future.compareAndSet(responseFuture, null);
                }
            });
        }
    }
}

