/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.ProcedureRegistry;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnIdentity;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableIdentity;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.GrantInfo;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Provider;

public class MetadataManager
implements Metadata {
    private final FunctionRegistry functions;
    private final ProcedureRegistry procedures;
    private final TypeManager typeManager;
    private final JsonCodec<ViewDefinition> viewCodec;
    private final BlockEncodingSerde blockEncodingSerde;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final TransactionManager transactionManager;
    private final ConcurrentMap<String, Collection<ConnectorMetadata>> catalogsByQueryId = new ConcurrentHashMap<String, Collection<ConnectorMetadata>>();

    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, TransactionManager transactionManager) {
        this(featuresConfig, typeManager, MetadataManager.createTestingViewCodec(), blockEncodingSerde, sessionPropertyManager, schemaPropertyManager, tablePropertyManager, transactionManager);
    }

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, JsonCodec<ViewDefinition> viewCodec, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, TransactionManager transactionManager) {
        this.functions = new FunctionRegistry(typeManager, blockEncodingSerde, featuresConfig);
        this.procedures = new ProcedureRegistry(typeManager);
        this.typeManager = Objects.requireNonNull(typeManager, "types is null");
        this.viewCodec = Objects.requireNonNull(viewCodec, "viewCodec is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.verifyComparableOrderableContract();
    }

    public static MetadataManager createTestMetadataManager() {
        return MetadataManager.createTestMetadataManager(new CatalogManager());
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager) {
        TypeRegistry typeManager = new TypeRegistry();
        return new MetadataManager(new FeaturesConfig(), typeManager, new BlockEncodingManager((TypeManager)typeManager, new BlockEncodingFactory[0]), new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), TransactionManager.createTestTransactionManager(catalogManager));
    }

    @Override
    public final void verifyComparableOrderableContract() {
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : this.typeManager.getTypes()) {
            if (type.isComparable()) {
                if (!this.functions.canResolveOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.HASH_CODE);
                }
                if (!this.functions.canResolveOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.EQUAL);
                }
                if (!this.functions.canResolveOperator(OperatorType.NOT_EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.NOT_EQUAL);
                }
            }
            if (!type.isOrderable()) continue;
            for (OperatorType operator : ImmutableList.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL)) {
                if (this.functions.canResolveOperator(operator, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) continue;
                missingOperators.put((Object)type, (Object)operator);
            }
            if (this.functions.canResolveOperator(OperatorType.BETWEEN, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type, (Object)type))) continue;
            missingOperators.put((Object)type, (Object)OperatorType.BETWEEN);
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.typeManager.getType(signature);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<SqlFunction> listFunctions() {
        return this.functions.list();
    }

    @Override
    public void addFunctions(List<? extends SqlFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, schema.getCatalogName());
        if (!catalog.isPresent()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getConnectorId());
        return catalogMetadata.listConnectorIds().stream().map(catalogMetadata::getMetadataFor).anyMatch(metadata -> metadata.schemaExists(connectorSession, schema.getSchemaName()));
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getConnectorId());
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                schemaNames.addAll((Iterable)metadata.listSchemaNames(connectorSession));
            }
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        ConnectorId connectorId;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(connectorId = catalogMetadata.getConnectorId(table))).getTableHandle(session.toConnectorSession(connectorId), table.asSchemaTableName())) != null) {
            return Optional.of(new TableHandle(connectorId, tableHandle));
        }
        return Optional.empty();
    }

    @Override
    public List<TableLayoutResult> getLayouts(Session session, TableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        if (constraint.getSummary().isNone()) {
            return ImmutableList.of();
        }
        ConnectorId connectorId = table.getConnectorId();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        List layouts = metadata.getTableLayouts(connectorSession, connectorTable, constraint, desiredColumns);
        return (List)layouts.stream().map(layout -> new TableLayoutResult(TableLayout.fromConnectorLayout(connectorId, transaction, layout.getTableLayout()), (TupleDomain<ColumnHandle>)layout.getUnenforcedConstraint())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public TableLayout getLayout(Session session, TableLayoutHandle handle) {
        ConnectorId connectorId = handle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(connectorId);
        return TableLayout.fromConnectorLayout(connectorId, transaction, metadata.getTableLayout(session.toConnectorSession(connectorId), handle.getConnectorHandle()));
    }

    @Override
    public Optional<Object> getInfo(Session session, TableLayoutHandle handle) {
        ConnectorId connectorId = handle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        ConnectorTableLayout tableLayout = metadata.getTableLayout(session.toConnectorSession(connectorId), handle.getConnectorHandle());
        return metadata.getInfo(tableLayout.getHandle());
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new TableMetadata(connectorId, tableMetadata);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), mapEntry.getValue());
        }
        return map.build();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.getColumnMetadata(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet tables = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            String schemaNameOrNull = prefix.getSchemaName().orElse(null);
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                metadata.listTables(connectorSession, schemaNameOrNull).stream().map(arg_0 -> QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName()).apply(arg_0)).forEach(tables::add);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Map<QualifiedObjectName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        HashMap tableColumns = new HashMap();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                QualifiedObjectName tableName;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                    tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    tableColumns.put(tableName, entry.getValue());
                }
                for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                    tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    ImmutableList.Builder columns = ImmutableList.builder();
                    for (ViewDefinition.ViewColumn column : this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()).getColumns()) {
                        columns.add((Object)new ColumnMetadata(column.getName(), column.getType()));
                    }
                    tableColumns.put(tableName, columns.build());
                }
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createSchema(session.toConnectorSession(connectorId), schema.getSchemaName(), properties);
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropSchema(session.toConnectorSession(connectorId), schema.getSchemaName());
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameSchema(session.toConnectorSession(connectorId), source.getSchemaName(), target);
    }

    @Override
    public TableIdentity getTableIdentity(Session session, TableHandle tableHandle) {
        ConnectorMetadata metadata = this.getMetadata(session, tableHandle.getConnectorId());
        return metadata.getTableIdentity(tableHandle.getConnectorHandle());
    }

    @Override
    public TableIdentity deserializeTableIdentity(Session session, String catalogName, byte[] bytes) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        return catalogMetadata.getMetadata().deserializeTableIdentity(bytes);
    }

    @Override
    public ColumnIdentity getColumnIdentity(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        ConnectorMetadata metadata = this.getMetadata(session, tableHandle.getConnectorId());
        return metadata.getColumnIdentity(columnHandle);
    }

    @Override
    public ColumnIdentity deserializeColumnIdentity(Session session, String catalogName, byte[] bytes) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        return catalogMetadata.getMetadata().deserializeColumnIdentity(bytes);
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createTable(session.toConnectorSession(connectorId), tableMetadata);
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        if (!tableHandle.getConnectorId().equals(connectorId)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameTable(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.renameColumn(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.addColumn(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.dropTable(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<NewTableLayout> getInsertLayout(Session session, TableHandle table) {
        ConnectorId connectorId = table.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        Optional insertLayout = metadata.getInsertLayout(session.toConnectorSession(connectorId), table.getConnectorHandle());
        if (!insertLayout.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new NewTableLayout(connectorId, catalogMetadata.getTransactionHandleFor(connectorId), (ConnectorNewTableLayout)insertLayout.get()));
    }

    @Override
    public Optional<NewTableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new NewTableLayout(connectorId, transactionHandle, (ConnectorNewTableLayout)layout));
    }

    @Override
    public void beginQuery(Session session, Set<ConnectorId> connectors) {
        for (ConnectorId connectorId : connectors) {
            ConnectorMetadata metadata = this.getMetadata(session, connectorId);
            ConnectorSession connectorSession = session.toConnectorSession(connectorId);
            metadata.beginQuery(connectorSession);
            this.registerCatalogForQueryId(session.getQueryId(), metadata);
        }
    }

    private void registerCatalogForQueryId(QueryId queryId, ConnectorMetadata metadata) {
        this.catalogsByQueryId.putIfAbsent(queryId.getId(), new ArrayList());
        ((Collection)this.catalogsByQueryId.get(queryId.getId())).add(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupQuery(Session session) {
        try {
            Collection catalogs = (Collection)this.catalogsByQueryId.get(session.getQueryId().getId());
            if (catalogs == null) {
                return;
            }
            for (ConnectorMetadata metadata : catalogs) {
                metadata.cleanupQuery(session.toConnectorSession());
            }
        }
        finally {
            this.catalogsByQueryId.remove(session.getQueryId().getId());
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(NewTableLayout::getLayout));
        return new OutputTableHandle(connectorId, transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.finishCreateTable(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.finishInsert(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.getUpdateRowIdColumnHandle(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
    }

    @Override
    public boolean supportsMetadataDelete(Session session, TableHandle tableHandle, TableLayoutHandle tableLayoutHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.supportsMetadataDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), tableLayoutHandle.getConnectorHandle());
    }

    @Override
    public OptionalLong metadataDelete(Session session, TableHandle tableHandle, TableLayoutHandle tableLayoutHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        return metadata.metadataDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), tableLayoutHandle.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        ConnectorTableHandle newHandle = metadata.beginDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getConnectorId(), newHandle);
    }

    @Override
    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        metadata.finishDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Optional<ConnectorId> getCatalogHandle(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName).map(CatalogMetadata::getConnectorId);
    }

    @Override
    public Map<String, ConnectorId> getCatalogNames(Session session) {
        return this.transactionManager.getCatalogNames(session.getRequiredTransactionId());
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet views = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            String schemaNameOrNull = prefix.getSchemaName().orElse(null);
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                metadata.listViews(connectorSession, schemaNameOrNull).stream().map(arg_0 -> QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName()).apply(arg_0)).forEach(views::add);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ViewDefinition> views = new LinkedHashMap<QualifiedObjectName, ViewDefinition>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()));
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        ConnectorId connectorId;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        Map views;
        ConnectorViewDefinition view;
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent() && (view = (ConnectorViewDefinition)(views = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(connectorId = catalogMetadata.getConnectorId(viewName))).getViews(session.toConnectorSession(connectorId), viewName.asSchemaTableName().toSchemaTablePrefix())).get(viewName.asSchemaTableName())) != null) {
            return Optional.of(this.deserializeView(view.getViewData()));
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, String viewData, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createView(session.toConnectorSession(connectorId), viewName.asSchemaTableName(), viewData, replace);
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropView(session.toConnectorSession(connectorId), viewName.asSchemaTableName());
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getConnectorId(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantTablePrivileges(session.toConnectorSession(connectorId), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeTablePrivileges(session.toConnectorSession(connectorId), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        ImmutableSet.Builder grantInfos = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getConnectorId());
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                grantInfos.addAll((Iterable)metadata.listTablePrivileges(connectorSession, tablePrefix));
            }
        }
        return ImmutableList.copyOf((Collection)grantInfos.build());
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functions;
    }

    @Override
    public ProcedureRegistry getProcedureRegistry() {
        return this.procedures;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return this.blockEncodingSerde;
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public SchemaPropertyManager getSchemaPropertyManager() {
        return this.schemaPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    private ViewDefinition deserializeView(String data) {
        try {
            return (ViewDefinition)this.viewCodec.fromJson(data);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Invalid view JSON: " + data, (Throwable)e);
        }
    }

    private Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
    }

    private CatalogMetadata getCatalogMetadata(Session session, ConnectorId connectorId) {
        return this.transactionManager.getCatalogMetadata(session.getRequiredTransactionId(), connectorId);
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, String catalogName) {
        return this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, ConnectorId connectorId) {
        return this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), connectorId);
    }

    private ConnectorMetadata getMetadata(Session session, ConnectorId connectorId) {
        return this.getCatalogMetadata(session, connectorId).getMetadataFor(connectorId);
    }

    private ConnectorMetadata getMetadataForWrite(Session session, ConnectorId connectorId) {
        return this.getCatalogMetadataForWrite(session, connectorId).getMetadata();
    }

    private static JsonCodec<ViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(new TypeRegistry()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ViewDefinition.class);
    }

    @VisibleForTesting
    public Map<String, Collection<ConnectorMetadata>> getCatalogsByQueryId() {
        return ImmutableMap.copyOf(this.catalogsByQueryId);
    }
}

