/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.presto.execution.SplitConcurrencyController;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.executor.PrioritizedSplitRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleSupplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TaskHandle {
    private final TaskId taskId;
    private final DoubleSupplier utilizationSupplier;
    @GuardedBy(value="this")
    private final Queue<PrioritizedSplitRunner> queuedLeafSplits = new ArrayDeque<PrioritizedSplitRunner>(10);
    @GuardedBy(value="this")
    private final List<PrioritizedSplitRunner> runningLeafSplits = new ArrayList<PrioritizedSplitRunner>(10);
    @GuardedBy(value="this")
    private final List<PrioritizedSplitRunner> runningIntermediateSplits = new ArrayList<PrioritizedSplitRunner>(10);
    @GuardedBy(value="this")
    private long taskThreadUsageNanos;
    @GuardedBy(value="this")
    private boolean destroyed;
    @GuardedBy(value="this")
    private final SplitConcurrencyController concurrencyController;
    private final AtomicInteger nextSplitId = new AtomicInteger();

    public TaskHandle(TaskId taskId, DoubleSupplier utilizationSupplier, int initialSplitConcurrency, Duration splitConcurrencyAdjustFrequency) {
        this.taskId = taskId;
        this.utilizationSupplier = utilizationSupplier;
        this.concurrencyController = new SplitConcurrencyController(initialSplitConcurrency, splitConcurrencyAdjustFrequency);
    }

    public synchronized long addThreadUsageNanos(long durationNanos) {
        this.concurrencyController.update(durationNanos, this.utilizationSupplier.getAsDouble(), this.runningLeafSplits.size());
        this.taskThreadUsageNanos += durationNanos;
        return this.taskThreadUsageNanos;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized List<PrioritizedSplitRunner> destroy() {
        this.destroyed = true;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.runningIntermediateSplits);
        builder.addAll(this.runningLeafSplits);
        builder.addAll(this.queuedLeafSplits);
        this.runningIntermediateSplits.clear();
        this.runningLeafSplits.clear();
        this.queuedLeafSplits.clear();
        return builder.build();
    }

    public synchronized void enqueueSplit(PrioritizedSplitRunner split) {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Cannot add split to destroyed task handle");
        this.queuedLeafSplits.add(split);
    }

    public synchronized void recordIntermediateSplit(PrioritizedSplitRunner split) {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Cannot add split to destroyed task handle");
        this.runningIntermediateSplits.add(split);
    }

    @VisibleForTesting
    public synchronized int getRunningLeafSplits() {
        return this.runningLeafSplits.size();
    }

    public synchronized long getThreadUsageNanos() {
        return this.taskThreadUsageNanos;
    }

    public synchronized PrioritizedSplitRunner pollNextSplit() {
        if (this.destroyed) {
            return null;
        }
        if (this.runningLeafSplits.size() >= this.concurrencyController.getTargetConcurrency()) {
            return null;
        }
        PrioritizedSplitRunner split = this.queuedLeafSplits.poll();
        if (split != null) {
            this.runningLeafSplits.add(split);
        }
        return split;
    }

    public synchronized void splitComplete(PrioritizedSplitRunner split) {
        this.concurrencyController.splitFinished(split.getScheduledNanos(), this.utilizationSupplier.getAsDouble(), this.runningLeafSplits.size());
        this.runningIntermediateSplits.remove(split);
        this.runningLeafSplits.remove(split);
    }

    public int getNextSplitId() {
        return this.nextSplitId.getAndIncrement();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).toString();
    }
}

