/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class StageStateMachine {
    private static final Logger log = Logger.get(StageStateMachine.class);
    private final StageId stageId;
    private final URI location;
    private final PlanFragment fragment;
    private final Session session;
    private final SplitSchedulerStats scheduledStats;
    private final StateMachine<StageState> stageState;
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<DateTime> schedulingComplete = new AtomicReference();
    private final Distribution getSplitDistribution = new Distribution();
    private final Distribution scheduleTaskDistribution = new Distribution();
    private final Distribution addSplitDistribution = new Distribution();
    private final AtomicLong peakMemory = new AtomicLong();
    private final AtomicLong currentMemory = new AtomicLong();

    public StageStateMachine(StageId stageId, URI location, Session session, PlanFragment fragment, ExecutorService executor, SplitSchedulerStats schedulerStats) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.fragment = Objects.requireNonNull(fragment, "fragment is null");
        this.scheduledStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.stageState = new StateMachine<StageState>("stage " + stageId, executor, StageState.PLANNED, StageState.TERMINAL_STAGE_STATES);
        this.stageState.addStateChangeListener((T state) -> log.debug("Stage %s is %s", new Object[]{stageId, state}));
    }

    public StageId getStageId() {
        return this.stageId;
    }

    public URI getLocation() {
        return this.location;
    }

    public Session getSession() {
        return this.session;
    }

    public StageState getState() {
        return this.stageState.get();
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<StageState> stateChangeListener) {
        this.stageState.addStateChangeListener(stateChangeListener);
    }

    public synchronized boolean transitionToScheduling() {
        return this.stageState.compareAndSet(StageState.PLANNED, StageState.SCHEDULING);
    }

    public synchronized boolean transitionToSchedulingSplits() {
        return this.stageState.setIf(StageState.SCHEDULING_SPLITS, currentState -> currentState == StageState.PLANNED || currentState == StageState.SCHEDULING);
    }

    public synchronized boolean transitionToScheduled() {
        this.schedulingComplete.compareAndSet(null, DateTime.now());
        return this.stageState.setIf(StageState.SCHEDULED, currentState -> currentState == StageState.PLANNED || currentState == StageState.SCHEDULING || currentState == StageState.SCHEDULING_SPLITS);
    }

    public boolean transitionToRunning() {
        return this.stageState.setIf(StageState.RUNNING, currentState -> currentState != StageState.RUNNING && !currentState.isDone());
    }

    public boolean transitionToFinished() {
        return this.stageState.setIf(StageState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToCanceled() {
        return this.stageState.setIf(StageState.CANCELED, currentState -> !currentState.isDone());
    }

    public boolean transitionToAborted() {
        return this.stageState.setIf(StageState.ABORTED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.stageState.setIf(StageState.FAILED, currentState -> !currentState.isDone());
        if (failed) {
            log.error(throwable, "Stage %s failed", new Object[]{this.stageId});
        } else {
            log.debug(throwable, "Failure after stage %s finished", new Object[]{this.stageId});
        }
        return failed;
    }

    public long getPeakMemoryInBytes() {
        return this.peakMemory.get();
    }

    public long getMemoryReservation() {
        return this.currentMemory.get();
    }

    public void updateMemoryUsage(long deltaMemoryInBytes) {
        long currentMemoryValue = this.currentMemory.addAndGet(deltaMemoryInBytes);
        if (currentMemoryValue > this.peakMemory.get()) {
            this.peakMemory.updateAndGet(x -> currentMemoryValue > x ? currentMemoryValue : x);
        }
    }

    public StageInfo getStageInfo(Supplier<Iterable<TaskInfo>> taskInfosSupplier, Supplier<Iterable<StageInfo>> subStageInfosSupplier) {
        StageState state = this.stageState.get();
        ImmutableList taskInfos = ImmutableList.copyOf(taskInfosSupplier.get());
        ImmutableList subStageInfos = ImmutableList.copyOf(subStageInfosSupplier.get());
        int totalTasks = taskInfos.size();
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long cumulativeMemory = 0L;
        long totalMemoryReservation = 0L;
        long peakMemoryReservation = this.getPeakMemoryInBytes();
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long bufferedDataSize = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        HashMap<String, OperatorStats> operatorToStats = new HashMap<String, OperatorStats>();
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            if (taskState.isDone()) {
                ++completedTasks;
            } else {
                ++runningTasks;
            }
            TaskStats taskStats = taskInfo.getStats();
            totalDrivers += taskStats.getTotalDrivers();
            queuedDrivers += taskStats.getQueuedDrivers();
            runningDrivers += taskStats.getRunningDrivers();
            completedDrivers += taskStats.getCompletedDrivers();
            cumulativeMemory = (long)((double)cumulativeMemory + taskStats.getCumulativeMemory());
            totalMemoryReservation += taskStats.getMemoryReservation().toBytes();
            totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += taskStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += taskStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (!taskState.isDone()) {
                fullyBlocked &= taskStats.isFullyBlocked();
                blockedReasons.addAll(taskStats.getBlockedReasons());
            }
            rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
            rawInputPositions += taskStats.getRawInputPositions();
            processedInputDataSize += taskStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += taskStats.getProcessedInputPositions();
            bufferedDataSize += taskInfo.getOutputBuffers().getTotalBufferedBytes();
            outputDataSize += taskStats.getOutputDataSize().toBytes();
            outputPositions += taskStats.getOutputPositions();
            for (PipelineStats pipeline : taskStats.getPipelines()) {
                for (OperatorStats operatorStats : pipeline.getOperatorSummaries()) {
                    String id = pipeline.getPipelineId() + "." + operatorStats.getOperatorId();
                    operatorToStats.compute(id, (k, v) -> v == null ? operatorStats : v.add(operatorStats));
                }
            }
        }
        StageStats stageStats = new StageStats(this.schedulingComplete.get(), this.getSplitDistribution.snapshot(), this.scheduleTaskDistribution.snapshot(), this.addSplitDistribution.snapshot(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, cumulativeMemory, DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)peakMemoryReservation), Duration.succinctDuration((double)totalScheduledTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalUserTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalBlockedTime, (TimeUnit)TimeUnit.NANOSECONDS), fullyBlocked && runningTasks > 0, blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)bufferedDataSize), DataSize.succinctBytes((long)outputDataSize), outputPositions, (List<OperatorStats>)ImmutableList.copyOf(operatorToStats.values()));
        ExecutionFailureInfo failureInfo = null;
        if (state == StageState.FAILED) {
            failureInfo = this.failureCause.get();
        }
        return new StageInfo(this.stageId, state, this.location, this.fragment, this.fragment.getTypes(), stageStats, (List<TaskInfo>)taskInfos, (List<StageInfo>)subStageInfos, failureInfo);
    }

    public void recordGetSplitTime(long startNanos) {
        long elapsedNanos = System.nanoTime() - startNanos;
        this.getSplitDistribution.add(elapsedNanos);
        this.scheduledStats.getGetSplitTime().add((double)elapsedNanos, TimeUnit.NANOSECONDS);
    }

    public void recordScheduleTaskTime(long startNanos) {
        this.scheduleTaskDistribution.add(System.nanoTime() - startNanos);
    }

    public void recordAddSplit(long startNanos) {
        this.addSplitDistribution.add(System.nanoTime() - startNanos);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("stageState", this.stageState).toString();
    }
}

