/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.transaction.TransactionManager;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FailedQueryExecution
implements QueryExecution {
    private final QueryInfo queryInfo;
    private final Session session;
    private final Executor executor;
    private final Optional<ResourceGroupId> resourceGroup;

    public FailedQueryExecution(QueryId queryId, String query, Optional<ResourceGroupId> resourceGroup, Session session, URI self, TransactionManager transactionManager, Executor executor, Metadata metadata, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        QueryStateMachine queryStateMachine = QueryStateMachine.failed(queryId, query, session, self, transactionManager, executor, metadata, cause);
        this.queryInfo = queryStateMachine.updateQueryInfo(Optional.empty());
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
    }

    @Override
    public QueryId getQueryId() {
        return this.queryInfo.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public QueryState getState() {
        return this.queryInfo.getState();
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L);
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
    }

    @Override
    public long getTotalMemoryReservation() {
        return 0L;
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.SECONDS);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void start() {
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return maxWait;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(QueryState.FAILED));
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(this.queryInfo));
    }

    @Override
    public void fail(Throwable cause) {
    }

    @Override
    public void cancelQuery() {
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public Optional<ResourceGroupId> getResourceGroup() {
        return this.resourceGroup;
    }

    @Override
    public void setResourceGroup(ResourceGroupId resourceGroupId) {
        throw new UnsupportedOperationException("setResouceGroup is not supported for FailedQueryExecution");
    }
}

