/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.maps;

import com.google.common.base.Equivalence;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class IdentityLinkedHashMap<K, V>
implements Map<K, V> {
    private final Map<Equivalence.Wrapper<K>, V> delegate = new LinkedHashMap<Equivalence.Wrapper<K>, V>();
    private final Equivalence<Object> equivalence = Equivalence.identity();

    public IdentityLinkedHashMap() {
    }

    public IdentityLinkedHashMap(IdentityLinkedHashMap<K, V> map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(this.equivalence.wrap(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(this.equivalence.wrap(key));
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(this.equivalence.wrap(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(this.equivalence.wrap(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.entrySet().forEach((? super T e) -> this.delegate.put(this.equivalence.wrap(e.getKey()), e.getValue()));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return IdentityLinkedHashMap.this.delegate.keySet().stream().map(Equivalence.Wrapper::get).iterator();
            }

            @Override
            public int size() {
                return IdentityLinkedHashMap.this.delegate.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return IdentityLinkedHashMap.this.delegate.entrySet().stream().map(e -> {
                    Object key = ((Equivalence.Wrapper)e.getKey()).get();
                    return new AbstractMap.SimpleEntry(key, e.getValue());
                }).iterator();
            }

            @Override
            public int size() {
                return IdentityLinkedHashMap.this.delegate.size();
            }
        };
    }
}

