/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.DateTimeUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static JsonParser createJsonParser(JsonFactory factory, Slice json) throws IOException {
        return factory.createParser((InputStream)json.getInput());
    }

    public static JsonGenerator createJsonGenerator(JsonFactory factory, SliceOutput output) throws IOException {
        return factory.createGenerator((OutputStream)output);
    }

    public static boolean canCastToJson(Type type) {
        String baseType = type.getTypeSignature().getBase();
        if (baseType.equals("unknown") || baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("real") || baseType.equals("double") || baseType.equals("decimal") || baseType.equals("varchar") || baseType.equals("json") || baseType.equals("timestamp") || baseType.equals("date")) {
            return true;
        }
        if (type instanceof ArrayType) {
            return JsonUtil.canCastToJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return JsonUtil.isValidJsonObjectKeyType(((MapType)type).getKeyType()) && JsonUtil.canCastToJson(((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            return type.getTypeParameters().stream().allMatch(JsonUtil::canCastToJson);
        }
        return false;
    }

    private static boolean isValidJsonObjectKeyType(Type type) {
        String baseType = type.getTypeSignature().getBase();
        return baseType.equals("unknown") || baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("real") || baseType.equals("double") || baseType.equals("decimal") || baseType.equals("varchar");
    }

    private static class RowJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final RowType type;
        private final List<JsonGeneratorWriter> fieldWriters;

        public RowJsonGeneratorWriter(RowType type, List<JsonGeneratorWriter> fieldWriters) {
            this.type = type;
            this.fieldWriters = fieldWriters;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block rowBlock = this.type.getObject(block, position);
                jsonGenerator.writeStartArray();
                for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                    this.fieldWriters.get(i).writeJsonValue(jsonGenerator, rowBlock, i, session);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }

    private static class MapJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final MapType type;
        private final ObjectKeyProvider keyProvider;
        private final JsonGeneratorWriter valueWriter;

        public MapJsonGeneratorWriter(MapType type, ObjectKeyProvider keyProvider, JsonGeneratorWriter valueWriter) {
            this.type = type;
            this.keyProvider = keyProvider;
            this.valueWriter = valueWriter;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block mapBlock = this.type.getObject(block, position);
                TreeMap<String, Integer> orderedKeyToValuePosition = new TreeMap<String, Integer>();
                for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                    String objectKey = this.keyProvider.getObjectKey(mapBlock, i);
                    orderedKeyToValuePosition.put(objectKey, i + 1);
                }
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : orderedKeyToValuePosition.entrySet()) {
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    this.valueWriter.writeJsonValue(jsonGenerator, mapBlock, (Integer)entry.getValue(), session);
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    private static class ArrayJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final ArrayType type;
        private final JsonGeneratorWriter elementWriter;

        public ArrayJsonGeneratorWriter(ArrayType type, JsonGeneratorWriter elementWriter) {
            this.type = type;
            this.elementWriter = elementWriter;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block arrayBlock = this.type.getObject(block, position);
                jsonGenerator.writeStartArray();
                for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                    this.elementWriter.writeJsonValue(jsonGenerator, arrayBlock, i, session);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }

    private static class DateGeneratorWriter
    implements JsonGeneratorWriter {
        private DateGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = DateType.DATE.getLong(block, position);
                jsonGenerator.writeString(DateTimeUtils.printDate((int)value));
            }
        }
    }

    private static class TimestampJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private TimestampJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = TimestampType.TIMESTAMP.getLong(block, position);
                jsonGenerator.writeString(DateTimeUtils.printTimestampWithoutTimeZone(session.getTimeZoneKey(), value));
            }
        }
    }

    private static class JsonJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private JsonJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Slice value = JsonType.JSON.getSlice(block, position);
                jsonGenerator.writeRawValue(value.toStringUtf8());
            }
        }
    }

    private static class VarcharJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final Type type;

        public VarcharJsonGeneratorWriter(Type type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Slice value = this.type.getSlice(block, position);
                jsonGenerator.writeString(value.toStringUtf8());
            }
        }
    }

    private static class LongDeicmalJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final DecimalType type;

        public LongDeicmalJsonGeneratorWriter(DecimalType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                BigDecimal value = new BigDecimal(Decimals.decodeUnscaledValue((Slice)this.type.getSlice(block, position)), this.type.getScale());
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class ShortDecimalJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final DecimalType type;

        public ShortDecimalJsonGeneratorWriter(DecimalType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                BigDecimal value = BigDecimal.valueOf(this.type.getLong(block, position), this.type.getScale());
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class DoubleJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private DoubleJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                double value = DoubleType.DOUBLE.getDouble(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class RealJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private RealJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                float value = Float.intBitsToFloat((int)RealType.REAL.getLong(block, position));
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class LongJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final Type type;

        public LongJsonGeneratorWriter(Type type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = this.type.getLong(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class BooleanJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private BooleanJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                boolean value = BooleanType.BOOLEAN.getBoolean(block, position);
                jsonGenerator.writeBoolean(value);
            }
        }
    }

    private static class UnknownJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private UnknownJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, ConnectorSession session) throws IOException {
            jsonGenerator.writeNull();
        }
    }

    public static interface JsonGeneratorWriter {
        public void writeJsonValue(JsonGenerator var1, Block var2, int var3, ConnectorSession var4) throws IOException;

        public static JsonGeneratorWriter createJsonGeneratorWriter(Type type) {
            String baseType;
            switch (baseType = type.getTypeSignature().getBase()) {
                case "unknown": {
                    return new UnknownJsonGeneratorWriter();
                }
                case "boolean": {
                    return new BooleanJsonGeneratorWriter();
                }
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    return new LongJsonGeneratorWriter(type);
                }
                case "real": {
                    return new RealJsonGeneratorWriter();
                }
                case "double": {
                    return new DoubleJsonGeneratorWriter();
                }
                case "decimal": {
                    if (Decimals.isShortDecimal((Type)type)) {
                        return new ShortDecimalJsonGeneratorWriter((DecimalType)type);
                    }
                    return new LongDeicmalJsonGeneratorWriter((DecimalType)type);
                }
                case "varchar": {
                    return new VarcharJsonGeneratorWriter(type);
                }
                case "json": {
                    return new JsonJsonGeneratorWriter();
                }
                case "timestamp": {
                    return new TimestampJsonGeneratorWriter();
                }
                case "date": {
                    return new DateGeneratorWriter();
                }
                case "array": {
                    ArrayType arrayType = (ArrayType)type;
                    return new ArrayJsonGeneratorWriter(arrayType, JsonGeneratorWriter.createJsonGeneratorWriter(arrayType.getElementType()));
                }
                case "map": {
                    MapType mapType = (MapType)type;
                    return new MapJsonGeneratorWriter(mapType, ObjectKeyProvider.createObjectKeyProvider(mapType.getKeyType()), JsonGeneratorWriter.createJsonGeneratorWriter(mapType.getValueType()));
                }
                case "row": {
                    List fieldTypes = type.getTypeParameters();
                    ArrayList<JsonGeneratorWriter> fieldWriters = new ArrayList<JsonGeneratorWriter>(fieldTypes.size());
                    for (int i = 0; i < fieldTypes.size(); ++i) {
                        fieldWriters.add(JsonGeneratorWriter.createJsonGeneratorWriter((Type)fieldTypes.get(i)));
                    }
                    return new RowJsonGeneratorWriter((RowType)type, fieldWriters);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }

    public static interface ObjectKeyProvider {
        public String getObjectKey(Block var1, int var2);

        public static ObjectKeyProvider createObjectKeyProvider(Type type) {
            String baseType;
            switch (baseType = type.getTypeSignature().getBase()) {
                case "unknown": {
                    return (block, position) -> null;
                }
                case "boolean": {
                    return (block, position) -> type.getBoolean(block, position) ? "true" : "false";
                }
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    return (block, position) -> String.valueOf(type.getLong(block, position));
                }
                case "real": {
                    return (block, position) -> String.valueOf(Float.intBitsToFloat((int)type.getLong(block, position)));
                }
                case "double": {
                    return (block, position) -> String.valueOf(type.getDouble(block, position));
                }
                case "decimal": {
                    DecimalType decimalType = (DecimalType)type;
                    if (Decimals.isShortDecimal((Type)decimalType)) {
                        return (block, position) -> Decimals.toString((long)decimalType.getLong(block, position), (int)decimalType.getScale());
                    }
                    return (block, position) -> Decimals.toString((BigInteger)Decimals.decodeUnscaledValue((Slice)type.getSlice(block, position)), (int)decimalType.getScale());
                }
                case "varchar": {
                    return (block, position) -> type.getSlice(block, position).toStringUtf8();
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }
}

