/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.ArrayBlockBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowType
extends AbstractType {
    private final List<RowField> fields;
    private final List<Type> fieldTypes;

    public RowType(List<Type> fieldTypes, Optional<List<String>> fieldNames) {
        super(new TypeSignature("row", Lists.transform(fieldTypes, Type::getTypeSignature), (List)fieldNames.orElse((List<String>)ImmutableList.of()).stream().collect(ImmutableList.toImmutableList())), Block.class);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            int index = i;
            builder.add((Object)new RowField(fieldTypes.get(i), fieldNames.map(names -> (String)names.get(index))));
        }
        this.fields = builder.build();
        this.fieldTypes = ImmutableList.copyOf(fieldTypes);
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder((BlockBuilder)new InterleavedBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries * this.getTypeParameters().size(), expectedBytesPerEntry), blockBuilderStatus, expectedEntries);
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return new ArrayBlockBuilder((BlockBuilder)new InterleavedBlockBuilder(this.getTypeParameters(), blockBuilderStatus, expectedEntries * this.getTypeParameters().size()), blockBuilderStatus, expectedEntries);
    }

    public String getDisplayName() {
        ArrayList<String> fieldDisplayNames = new ArrayList<String>();
        for (RowField field : this.fields) {
            String typeDisplayName = field.getType().getDisplayName();
            if (field.getName().isPresent()) {
                fieldDisplayNames.add(field.getName().get() + " " + typeDisplayName);
                continue;
            }
            fieldDisplayNames.add(typeDisplayName);
        }
        return "row(" + Joiner.on((String)", ").join(fieldDisplayNames) + ")";
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block arrayBlock = this.getObject(block, position);
        ArrayList<Object> values = new ArrayList<Object>(arrayBlock.getPositionCount());
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            values.add(this.fields.get(i).getType().getObjectValue(session, arrayBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeObject(block.getObject(position, Block.class));
            blockBuilder.closeEntry();
        }
    }

    public Block getObject(Block block, int position) {
        return (Block)block.getObject(position, Block.class);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.writeObject(value).closeEntry();
    }

    public List<Type> getTypeParameters() {
        return this.fieldTypes;
    }

    public List<RowField> getFields() {
        return this.fields;
    }

    public boolean isComparable() {
        return this.fields.stream().allMatch(field -> field.getType().isComparable());
    }

    public boolean isOrderable() {
        return this.fields.stream().allMatch(field -> field.getType().isOrderable());
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftRow = (Block)leftBlock.getObject(leftPosition, Block.class);
        Block rightRow = (Block)rightBlock.getObject(rightPosition, Block.class);
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            RowType.checkElementNotNull(leftRow.isNull(i));
            RowType.checkElementNotNull(rightRow.isNull(i));
            Type fieldType = this.fields.get(i).getType();
            if (fieldType.equalTo(leftRow, i, rightRow, i)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftRow = (Block)leftBlock.getObject(leftPosition, Block.class);
        Block rightRow = (Block)rightBlock.getObject(rightPosition, Block.class);
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            RowType.checkElementNotNull(leftRow.isNull(i));
            RowType.checkElementNotNull(rightRow.isNull(i));
            Type fieldType = this.fields.get(i).getType();
            if (!fieldType.isOrderable()) {
                throw new UnsupportedOperationException(fieldType.getTypeSignature() + " type is not orderable");
            }
            int compareResult = fieldType.compareTo(leftRow, i, rightRow, i);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }

    public long hash(Block block, int position) {
        Block arrayBlock = (Block)block.getObject(position, Block.class);
        long result = 1L;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            Type elementType = this.fields.get(i).getType();
            result = 31L * result + TypeUtils.hashPosition(elementType, arrayBlock, i);
        }
        return result;
    }

    private static void checkElementNotNull(boolean isNull) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        }
    }

    public static class RowField {
        private final Type type;
        private final Optional<String> name;

        public RowField(Type type, Optional<String> name) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

