/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.NamedType;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.ParametricType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.type.RowType;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    public String getName() {
        return "row";
    }

    public Type createType(List<TypeParameter> parameters) {
        Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0, (Object)"Row type must have at least one parameter");
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE), (String)"Expected only named types as a parameters, got %s", parameters);
        List namedTypes = parameters.stream().map(TypeParameter::getNamedType).collect(Collectors.toList());
        return new RowType(namedTypes.stream().map(NamedType::getType).collect(Collectors.toList()), Optional.of(namedTypes.stream().map(NamedType::getName).collect(Collectors.toList())));
    }
}

