/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class DateTimeOperators {
    private static final DateTimeField MILLIS_OF_DAY = ISOChronology.getInstanceUTC().millisOfDay();
    private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

    private DateTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long datePlusIntervalDayToSecond(@SqlType(value="date") long left, @SqlType(value="interval day to second") long right) {
        if (MILLIS_OF_DAY.get(right) != 0) {
            throw new IllegalArgumentException("Can not add hour, minutes or seconds to a Date");
        }
        return left + TimeUnit.MILLISECONDS.toDays(right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long intervalDayToSecondPlusDate(@SqlType(value="interval day to second") long left, @SqlType(value="date") long right) {
        if (MILLIS_OF_DAY.get(left) != 0) {
            throw new IllegalArgumentException("Can not add hour, minutes or seconds to a Date");
        }
        return TimeUnit.MILLISECONDS.toDays(left) + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long timePlusIntervalDayToSecond(ConnectorSession session, @SqlType(value="time") long left, @SqlType(value="interval day to second") long right) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), left + right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long intervalDayToSecondPlusTime(ConnectorSession session, @SqlType(value="interval day to second") long left, @SqlType(value="time") long right) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), left + right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZonePlusIntervalDayToSecond(@SqlType(value="time with time zone") long left, @SqlType(value="interval day to second") long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(left), DateTimeEncoding.unpackMillisUtc((long)left) + right), (long)left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long intervalDayToSecondPlusTimeWithTimeZone(@SqlType(value="interval day to second") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(right), left + DateTimeEncoding.unpackMillisUtc((long)right)), (long)right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long timestampPlusIntervalDayToSecond(@SqlType(value="timestamp") long left, @SqlType(value="interval day to second") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long intervalDayToSecondPlusTimestamp(@SqlType(value="interval day to second") long left, @SqlType(value="timestamp") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZonePlusIntervalDayToSecond(@SqlType(value="timestamp with time zone") long left, @SqlType(value="interval day to second") long right) {
        return DateTimeEncoding.updateMillisUtc((long)(DateTimeEncoding.unpackMillisUtc((long)left) + right), (long)left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long intervalDayToSecondPlusTimestampWithTimeZone(@SqlType(value="interval day to second") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.updateMillisUtc((long)(left + DateTimeEncoding.unpackMillisUtc((long)right)), (long)right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long datePlusIntervalYearToMonth(@SqlType(value="date") long left, @SqlType(value="interval year to month") long right) {
        long millis = MONTH_OF_YEAR_UTC.add(TimeUnit.DAYS.toMillis(left), right);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long intervalYearToMonthPlusDate(@SqlType(value="interval year to month") long left, @SqlType(value="date") long right) {
        long millis = MONTH_OF_YEAR_UTC.add(TimeUnit.DAYS.toMillis(right), left);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long timePlusIntervalYearToMonth(@SqlType(value="time") long left, @SqlType(value="interval year to month") long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time")
    public static long intervalYearToMonthPlusTime(@SqlType(value="interval year to month") long left, @SqlType(value="time") long right) {
        return right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZonePlusIntervalYearToMonth(@SqlType(value="time with time zone") long left, @SqlType(value="interval year to month") long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="time with time zone")
    public static long intervalYearToMonthPlusTimeWithTimeZone(@SqlType(value="interval year to month") long left, @SqlType(value="time with time zone") long right) {
        return right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long timestampPlusIntervalYearToMonth(ConnectorSession session, @SqlType(value="timestamp") long left, @SqlType(value="interval year to month") long right) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(left, right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp")
    public static long intervalYearToMonthPlusTimestamp(ConnectorSession session, @SqlType(value="interval year to month") long left, @SqlType(value="timestamp") long right) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(right, left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZonePlusIntervalYearToMonth(@SqlType(value="timestamp with time zone") long left, @SqlType(value="interval year to month") long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeZoneIndex.unpackChronology(left).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)left), right), (long)left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="timestamp with time zone")
    public static long intervalYearToMonthPlusTimestampWithTimeZone(@SqlType(value="interval year to month") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeZoneIndex.unpackChronology(right).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)right), left), (long)right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="date")
    public static long dateMinusIntervalDayToSecond(@SqlType(value="date") long left, @SqlType(value="interval day to second") long right) {
        if (MILLIS_OF_DAY.get(right) != 0) {
            throw new IllegalArgumentException("Can not subtract hour, minutes or seconds from a Date");
        }
        return left - TimeUnit.MILLISECONDS.toDays(right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time")
    public static long timeMinusIntervalDayToSecond(ConnectorSession session, @SqlType(value="time") long left, @SqlType(value="interval day to second") long right) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), left - right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZoneMinusIntervalDayToSecond(@SqlType(value="time with time zone") long left, @SqlType(value="interval day to second") long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(left), DateTimeEncoding.unpackMillisUtc((long)left) - right), (long)left);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp")
    public static long timestampMinusIntervalDayToSecond(@SqlType(value="timestamp") long left, @SqlType(value="interval day to second") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZoneMinusIntervalDayToSecond(@SqlType(value="timestamp with time zone") long left, @SqlType(value="interval day to second") long right) {
        return DateTimeEncoding.updateMillisUtc((long)(DateTimeEncoding.unpackMillisUtc((long)left) - right), (long)left);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="date")
    public static long dateMinusIntervalYearToMonth(ConnectorSession session, @SqlType(value="date") long left, @SqlType(value="interval year to month") long right) {
        long millis = MONTH_OF_YEAR_UTC.add(TimeUnit.DAYS.toMillis(left), -right);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time")
    public static long timeMinusIntervalYearToMonth(@SqlType(value="time") long left, @SqlType(value="interval year to month") long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="time with time zone")
    public static long timeWithTimeZoneMinusIntervalYearToMonth(@SqlType(value="time with time zone") long left, @SqlType(value="interval year to month") long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp")
    public static long timestampMinusIntervalYearToMonth(ConnectorSession session, @SqlType(value="timestamp") long left, @SqlType(value="interval year to month") long right) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(left, -right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="timestamp with time zone")
    public static long timestampWithTimeZoneMinusIntervalYearToMonth(@SqlType(value="timestamp with time zone") long left, @SqlType(value="interval year to month") long right) {
        long dateTimeWithTimeZone = DateTimeZoneIndex.unpackChronology(left).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)left), -right);
        return DateTimeEncoding.updateMillisUtc((long)dateTimeWithTimeZone, (long)left);
    }

    public static int modulo24Hour(ISOChronology chronology, long millis) {
        return chronology.millisOfDay().get(millis) - chronology.getZone().getOffset(millis);
    }
}

