/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.Chars;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;

public final class CharOperators {
    private CharOperators() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return left.equals((Object)right);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return !left.equals((Object)right);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) < 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) <= 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) > 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) >= 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="char(x)") Slice value, @SqlType(value="char(x)") Slice min, @SqlType(value="char(x)") Slice max) {
        return Chars.compareChars((Slice)min, (Slice)value) <= 0 && Chars.compareChars((Slice)value, (Slice)max) <= 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="char(x)") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="char(x)") Slice left, @IsNull boolean leftNull, @SqlType(value="char(x)") Slice right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return CharOperators.notEqual(left, right);
    }
}

