/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import io.airlift.units.DataSize;
import java.util.concurrent.Executor;

public final class TestingTaskContext {
    private TestingTaskContext() {
    }

    public static TaskContext createTaskContext(Executor executor, Session session) {
        return TestingTaskContext.createTaskContext(executor, session, new DataSize(256.0, DataSize.Unit.MEGABYTE));
    }

    public static TaskContext createTaskContext(Executor executor, Session session, DataSize maxMemory) {
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        MemoryPool systemMemoryPool = new MemoryPool(new MemoryPoolId("testSystem"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        QueryContext queryContext = new QueryContext(new QueryId("test_query"), maxMemory, memoryPool, systemMemoryPool, executor, new DataSize(1.0, DataSize.Unit.GIGABYTE), spillSpaceTracker);
        return TestingTaskContext.createTaskContext(queryContext, executor, session);
    }

    public static TaskContext createTaskContext(QueryContext queryContext, Executor executor, Session session) {
        return queryContext.addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0), executor), session, true, true);
    }
}

