/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.TestingHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestingMetadata
implements ConnectorMetadata {
    private final ConcurrentMap<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();
    private final ConcurrentMap<SchemaTableName, String> views = new ConcurrentHashMap<SchemaTableName, String>();

    public List<String> listSchemaNames(ConnectorSession session) {
        HashSet<String> schemaNames = new HashSet<String>();
        for (SchemaTableName schemaTableName : this.tables.keySet()) {
            schemaNames.add(schemaTableName.getSchemaName());
        }
        return ImmutableList.copyOf(schemaNames);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return new InMemoryTableHandle(tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        return ImmutableList.of();
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        throw new UnsupportedOperationException();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ConnectorTableMetadata tableMetadata = (ConnectorTableMetadata)this.tables.get(tableName);
        Preconditions.checkArgument((tableMetadata != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object)tableName);
        return tableMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new InMemoryColumnHandle(columnMetadata.getName(), index, columnMetadata.getType()));
            ++index;
        }
        return builder.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchemaName())) {
            ImmutableList.Builder columns = ImmutableList.builder();
            for (ColumnMetadata column : ((ConnectorTableMetadata)this.tables.get(tableName)).getColumns()) {
                columns.add((Object)new ColumnMetadata(column.getName(), column.getType()));
            }
            tableColumns.put((Object)tableName, (Object)columns.build());
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        int columnIndex = ((InMemoryColumnHandle)columnHandle).getOrdinalPosition();
        return (ColumnMetadata)((ConnectorTableMetadata)this.tables.get(tableName)).getColumns().get(columnIndex);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tables.keySet()) {
            if (schemaNameOrNull != null && !schemaNameOrNull.equals(tableName.getSchemaName())) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        ConnectorTableMetadata table = this.getTableMetadata(session, tableHandle);
        if (this.tables.putIfAbsent(newTableName, table) != null) {
            throw new IllegalArgumentException("Target table already exists: " + newTableName);
        }
        this.tables.remove(table.getTable(), table);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        ConnectorTableMetadata existingTable = this.tables.putIfAbsent(tableMetadata.getTable(), tableMetadata);
        Preconditions.checkArgument((existingTable == null ? 1 : 0) != 0, (String)"Table %s already exists", (Object)tableMetadata.getTable());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.tables.remove(TestingMetadata.getTableName(tableHandle));
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        if (replace) {
            this.views.put(viewName, viewData);
        } else if (this.views.putIfAbsent(viewName, viewData) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + viewName);
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName viewName : this.views.keySet()) {
            if (schemaNameOrNull != null && !schemaNameOrNull.equals(viewName.getSchemaName())) continue;
            builder.add((Object)viewName);
        }
        return builder.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry entry : this.views.entrySet()) {
            if (!prefix.matches((SchemaTableName)entry.getKey())) continue;
            map.put(entry.getKey(), (Object)new ConnectorViewDefinition((SchemaTableName)entry.getKey(), Optional.empty(), (String)entry.getValue()));
        }
        return map.build();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.createTable(session, tableMetadata);
        return TestingHandle.INSTANCE;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return TestingHandle.INSTANCE;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll((Iterable)tableMetadata.getColumns());
        columns.add((Object)column);
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)columns.build(), tableMetadata.getProperties()));
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ColumnMetadata columnMetadata = this.getColumnMetadata(session, tableHandle, source);
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
        columns.set(columns.indexOf(columnMetadata), new ColumnMetadata(target, columnMetadata.getType(), columnMetadata.getComment(), columnMetadata.isHidden()));
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)ImmutableList.copyOf(columns), tableMetadata.getProperties()));
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
    }

    public void clear() {
        this.views.clear();
        this.tables.clear();
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof InMemoryTableHandle), (Object)"tableHandle is not an instance of InMemoryTableHandle");
        InMemoryTableHandle inMemoryTableHandle = (InMemoryTableHandle)tableHandle;
        return inMemoryTableHandle.getTableName();
    }

    public static class InMemoryColumnHandle
    implements ColumnHandle {
        private final String name;
        private final int ordinalPosition;
        private final Type type;

        public InMemoryColumnHandle(String name, int ordinalPosition, Type type) {
            this.name = name;
            this.ordinalPosition = ordinalPosition;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static class InMemoryTableHandle
    implements ConnectorTableHandle {
        private final SchemaTableName tableName;

        public InMemoryTableHandle(SchemaTableName schemaTableName) {
            this.tableName = schemaTableName;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }
    }
}

