/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.joins.JoinGraph;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;

public class EliminateCrossJoins
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        if (!SystemSessionProperties.isJoinReorderingEnabled(session)) {
            return plan;
        }
        List<JoinGraph> joinGraphs = JoinGraph.buildFrom(plan);
        for (int i = joinGraphs.size() - 1; i >= 0; --i) {
            JoinGraph graph = joinGraphs.get(i);
            List<Integer> joinOrder = EliminateCrossJoins.getJoinOrder(graph);
            if (EliminateCrossJoins.isOriginalOrder(joinOrder)) continue;
            plan = SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, graph, joinOrder), plan);
        }
        return plan;
    }

    public static boolean isOriginalOrder(List<Integer> joinOrder) {
        for (int i = 0; i < joinOrder.size(); ++i) {
            if (joinOrder.get(i) == i) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> getJoinOrder(JoinGraph graph) {
        ImmutableList.Builder joinOrder = ImmutableList.builder();
        HashMap<PlanNodeId, Integer> priorities = new HashMap<PlanNodeId, Integer>();
        for (int i = 0; i < graph.size(); ++i) {
            priorities.put(graph.getNode(i).getId(), i);
        }
        PriorityQueue<PlanNode> nodesToVisit = new PriorityQueue<PlanNode>(graph.size(), (node1, node2) -> ((Integer)priorities.get(node1.getId())).compareTo((Integer)priorities.get(node2.getId())));
        HashSet<PlanNode> visited = new HashSet<PlanNode>();
        nodesToVisit.add(graph.getNode(0));
        while (!nodesToVisit.isEmpty()) {
            Optional<PlanNode> firstNotVisitedNode;
            PlanNode node3 = (PlanNode)nodesToVisit.poll();
            if (!visited.contains(node3)) {
                visited.add(node3);
                joinOrder.add((Object)node3);
                for (JoinGraph.Edge edge : graph.getEdges(node3)) {
                    nodesToVisit.add(edge.getTargetNode());
                }
            }
            if (!nodesToVisit.isEmpty() || visited.size() >= graph.size() || !(firstNotVisitedNode = graph.getNodes().stream().filter(graphNode -> !visited.contains(graphNode)).findFirst()).isPresent()) continue;
            nodesToVisit.add(firstNotVisitedNode.get());
        }
        Preconditions.checkState((visited.size() == graph.size() ? 1 : 0) != 0);
        return (List)joinOrder.build().stream().map(node -> (Integer)priorities.get(node.getId())).collect(ImmutableList.toImmutableList());
    }

    private class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final PlanNodeIdAllocator idAllocator;
        private final JoinGraph graph;
        private final List<Integer> joinOrder;

        public Rewriter(PlanNodeIdAllocator idAllocator, JoinGraph graph, List<Integer> joinOrder) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.graph = Objects.requireNonNull(graph, "graph is null");
            this.joinOrder = Objects.requireNonNull(joinOrder, "joinOrder is null");
            Preconditions.checkState((joinOrder.size() >= 2 ? 1 : 0) != 0);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            if (node.getId() != this.graph.getRootId()) {
                return context.defaultRewrite(node, context.get());
            }
            PlanNode result = this.graph.getNode(this.joinOrder.get(0));
            HashSet<PlanNodeId> alreadyJoinedNodes = new HashSet<PlanNodeId>();
            alreadyJoinedNodes.add(result.getId());
            for (int i = 1; i < this.joinOrder.size(); ++i) {
                PlanNode rightNode = this.graph.getNode(this.joinOrder.get(i));
                alreadyJoinedNodes.add(rightNode.getId());
                ImmutableList.Builder criteria = ImmutableList.builder();
                for (JoinGraph.Edge edge : this.graph.getEdges(rightNode)) {
                    PlanNode targetNode = edge.getTargetNode();
                    if (!alreadyJoinedNodes.contains(targetNode.getId())) continue;
                    criteria.add((Object)new JoinNode.EquiJoinClause(edge.getTargetSymbol(), edge.getSourceSymbol()));
                }
                result = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, result, rightNode, (List<JoinNode.EquiJoinClause>)criteria.build(), (List<Symbol>)ImmutableList.builder().addAll(result.getOutputSymbols()).addAll(rightNode.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            }
            List<Expression> filters = this.graph.getFilters();
            for (Expression filter : filters) {
                result = new FilterNode(this.idAllocator.getNextId(), result, filter);
            }
            if (this.graph.getAssignments().isPresent()) {
                result = new ProjectNode(this.idAllocator.getNextId(), result, Assignments.copyOf(this.graph.getAssignments().get()));
            }
            if (!result.getOutputSymbols().equals(node.getOutputSymbols())) {
                result = new ProjectNode(this.idAllocator.getNextId(), result, Assignments.identity(node.getOutputSymbols()));
            }
            return result;
        }
    }
}

