/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.FragmentTableScanCounter;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PreferredProperties;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.maps.IdentityLinkedHashMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AddExchanges
implements PlanOptimizer {
    private final SqlParser parser;
    private final Metadata metadata;

    public AddExchanges(Metadata metadata, SqlParser parser) {
        this.metadata = metadata;
        this.parser = parser;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Context context = new Context(PreferredProperties.any(), (List<Symbol>)ImmutableList.of());
        PlanWithProperties result = plan.accept(new Rewriter(idAllocator, symbolAllocator, session), context);
        return result.getNode();
    }

    private static Map<Symbol, Symbol> computeIdentityTranslations(Assignments assignments) {
        HashMap<Symbol, Symbol> outputToInput = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Expression> assignment : assignments.getMap().entrySet()) {
            if (!(assignment.getValue() instanceof SymbolReference)) continue;
            outputToInput.put(assignment.getKey(), Symbol.from(assignment.getValue()));
        }
        return outputToInput;
    }

    @VisibleForTesting
    static Comparator<ActualProperties> streamingExecutionPreference(final PreferredProperties preferred) {
        LoadingCache matchCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<List<LocalProperty<Symbol>>, List<Optional<LocalProperty<Symbol>>>>(){

            public List<Optional<LocalProperty<Symbol>>> load(List<LocalProperty<Symbol>> actualProperties) {
                return LocalProperties.match(actualProperties, preferred.getLocalProperties());
            }
        });
        return (actual1, actual2) -> {
            List matchLayout1 = (List)matchCache.getUnchecked(actual1.getLocalProperties());
            List matchLayout2 = (List)matchCache.getUnchecked(actual2.getLocalProperties());
            return ComparisonChain.start().compareTrueFirst(AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout1), AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout2)).compareTrueFirst(AddExchanges.meetsPartitioningRequirements(preferred, actual1), AddExchanges.meetsPartitioningRequirements(preferred, actual2)).compare((Object)matchLayout1, (Object)matchLayout2, AddExchanges.matchedLayoutPreference()).result();
        };
    }

    private static <T> boolean hasLocalOptimization(List<LocalProperty<T>> desiredLayout, List<Optional<LocalProperty<T>>> matchResult) {
        Preconditions.checkArgument((desiredLayout.size() == matchResult.size() ? 1 : 0) != 0);
        if (matchResult.isEmpty()) {
            return false;
        }
        return !matchResult.get(0).equals(Optional.of(desiredLayout.get(0)));
    }

    private static boolean meetsPartitioningRequirements(PreferredProperties preferred, ActualProperties actual) {
        if (!preferred.getGlobalProperties().isPresent()) {
            return true;
        }
        PreferredProperties.Global preferredGlobal = preferred.getGlobalProperties().get();
        if (!preferredGlobal.isDistributed()) {
            return actual.isSingleNode();
        }
        if (!preferredGlobal.getPartitioningProperties().isPresent()) {
            return !actual.isSingleNode();
        }
        return actual.isStreamPartitionedOn(preferredGlobal.getPartitioningProperties().get().getPartitioningColumns());
    }

    private static <T> Comparator<List<Optional<LocalProperty<T>>>> matchedLayoutPreference() {
        return (matchLayout1, matchLayout2) -> {
            Iterator match1Iterator = matchLayout1.iterator();
            Iterator match2Iterator = matchLayout2.iterator();
            while (match1Iterator.hasNext() && match2Iterator.hasNext()) {
                Optional match1 = (Optional)match1Iterator.next();
                Optional match2 = (Optional)match2Iterator.next();
                if (match1.isPresent() && match2.isPresent()) {
                    return Integer.compare(((LocalProperty)match1.get()).getColumns().size(), ((LocalProperty)match2.get()).getColumns().size());
                }
                if (match1.isPresent()) {
                    return 1;
                }
                if (!match2.isPresent()) continue;
                return -1;
            }
            Preconditions.checkState((!match1Iterator.hasNext() && !match2Iterator.hasNext() ? 1 : 0) != 0);
            return 0;
        };
    }

    @VisibleForTesting
    static class PlanWithProperties {
        private final PlanNode node;
        private final ActualProperties properties;

        public PlanWithProperties(PlanNode node, ActualProperties properties) {
            this.node = node;
            this.properties = properties;
        }

        public PlanNode getNode() {
            return this.node;
        }

        public ActualProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends PlanVisitor<Context, PlanWithProperties> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final Map<Symbol, Type> types;
        private final Session session;
        private final boolean distributedIndexJoins;
        private final boolean preferStreamingOperators;
        private final boolean redistributeWrites;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.types = ImmutableMap.copyOf(symbolAllocator.getTypes());
            this.session = session;
            this.distributedIndexJoins = SystemSessionProperties.isDistributedIndexJoinEnabled(session);
            this.redistributeWrites = SystemSessionProperties.isRedistributeWrites(session);
            this.preferStreamingOperators = SystemSessionProperties.preferStreamingOperators(session);
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, Context context) {
            return this.rebaseAndDeriveProperties(node, this.planChild(node, context));
        }

        @Override
        public PlanWithProperties visitProject(ProjectNode node, Context context) {
            Map identities = AddExchanges.computeIdentityTranslations(node.getAssignments());
            PreferredProperties translatedPreferred = context.getPreferredProperties().translate(symbol -> Optional.ofNullable(identities.get(symbol)));
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context.withPreferredProperties(translatedPreferred)));
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, Context context) {
            PlanWithProperties child;
            HashSet<Symbol> partitioningRequirement = new HashSet<Symbol>((Collection)node.getGroupingSets().get(0));
            for (int i = 1; i < node.getGroupingSets().size(); ++i) {
                partitioningRequirement.retainAll((Collection)node.getGroupingSets().get(i));
            }
            PreferredProperties preferredProperties = PreferredProperties.any();
            if (!node.getGroupingKeys().isEmpty()) {
                preferredProperties = PreferredProperties.partitionedWithLocal(partitioningRequirement, LocalProperties.grouped(node.getGroupingKeys())).mergeWithParent(context.getPreferredProperties());
            }
            if ((child = this.planChild(node, context.withPreferredProperties(preferredProperties))).getProperties().isSingleNode()) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (node.getGroupingSets().stream().anyMatch(List::isEmpty)) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            } else if (!child.getProperties().isStreamPartitionedOn(partitioningRequirement) && !child.getProperties().isNodePartitionedOn(partitioningRequirement)) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getGroupingKeys(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitGroupId(GroupIdNode node, Context context) {
            PreferredProperties childPreference = context.getPreferredProperties().translate(this.translateGroupIdSymbols(node));
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(childPreference));
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private Function<Symbol, Optional<Symbol>> translateGroupIdSymbols(GroupIdNode node) {
            return symbol -> {
                if (node.getArgumentMappings().containsKey(symbol)) {
                    return Optional.of(node.getArgumentMappings().get(symbol));
                }
                if (node.getCommonGroupingColumns().contains(symbol)) {
                    return Optional.of(node.getGroupingSetMappings().get(symbol));
                }
                return Optional.empty();
            };
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, Context context) {
            PreferredProperties preferredChildProperties = PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getDistinctSymbols()), LocalProperties.grouped(node.getDistinctSymbols())).mergeWithParent(context.getPreferredProperties());
            PlanWithProperties child = node.getSource().accept(this, context.withPreferredProperties(preferredChildProperties));
            if (child.getProperties().isSingleNode() || !child.getProperties().isStreamPartitionedOn(node.getDistinctSymbols())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getDistinctSymbols(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, Context context) {
            ArrayList<Object> desiredProperties = new ArrayList<Object>();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            for (Symbol symbol : node.getOrderBy()) {
                desiredProperties.add(new SortingProperty((Object)symbol, node.getOrderings().get(symbol)));
            }
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), desiredProperties).mergeWithParent(context.getPreferredProperties())));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy())) {
                child = node.getPartitionBy().isEmpty() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties()) : this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, Context context) {
            if (node.getPartitionBy().isEmpty()) {
                PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.undistributed()));
                if (!child.getProperties().isSingleNode()) {
                    child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
                }
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())).mergeWithParent(context.getPreferredProperties())));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, Context context) {
            Function<PlanNode, PlanNode> addExchange;
            PreferredProperties preferredChildProperties;
            if (node.getPartitionBy().isEmpty()) {
                preferredChildProperties = PreferredProperties.any();
                addExchange = partial -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, partial);
            } else {
                preferredChildProperties = PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())).mergeWithParent(context.getPreferredProperties());
                addExchange = partial -> ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, partial, node.getPartitionBy(), node.getHashSymbol());
            }
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(preferredChildProperties));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy())) {
                child = this.withDerivedProperties(new TopNRowNumberNode(this.idAllocator.getNextId(), child.getNode(), node.getSpecification(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), true, node.getHashSymbol()), child.getProperties());
                child = this.withDerivedProperties(addExchange.apply(child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(new TopNNode(this.idAllocator.getNextId(), child.getNode(), node.getCount(), node.getOrderBy(), node.getOrderings(), true), child.getProperties());
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.undistributed()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            } else {
                ArrayList desiredProperties = new ArrayList();
                for (Symbol symbol : node.getOrderBy()) {
                    desiredProperties.add(new SortingProperty((Object)symbol, node.getOrderings().get(symbol)));
                }
                if (LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).stream().noneMatch(Optional::isPresent)) {
                    return child;
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(new LimitNode(this.idAllocator.getNextId(), child.getNode(), node.getCount(), true), child.getProperties());
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, new DistinctLimitNode(this.idAllocator.getNextId(), child.getNode(), node.getLimit(), true, node.getHashSymbol())), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitFilter(FilterNode node, Context context) {
            if (node.getSource() instanceof TableScanNode) {
                return this.planTableScan((TableScanNode)node.getSource(), node.getPredicate(), context);
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context));
        }

        @Override
        public PlanWithProperties visitTableScan(TableScanNode node, Context context) {
            return this.planTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL, context);
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, Context context) {
            PlanWithProperties source = node.getSource().accept(this, context);
            Optional<PartitioningScheme> partitioningScheme = node.getPartitioningScheme();
            if (!partitioningScheme.isPresent() && this.redistributeWrites) {
                partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), source.getNode().getOutputSymbols()));
            }
            if (partitioningScheme.isPresent()) {
                source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, source.getNode(), partitioningScheme.get()), source.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, source);
        }

        private PlanWithProperties planTableScan(TableScanNode node, Expression predicate, Context context) {
            Expression deterministicPredicate = ExpressionUtils.stripNonDeterministicConjuncts(predicate);
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(AddExchanges.this.metadata, this.session, deterministicPredicate, this.types);
            TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getCurrentConstraint());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = DomainTranslator.toPredicate((TupleDomain<Symbol>)node.getCurrentConstraint().transform(((Map)assignments)::get));
            Expression constraint = ExpressionUtils.combineConjuncts(expressionArray);
            List<TableLayoutResult> layouts = AddExchanges.this.metadata.getLayouts(this.session, node.getTable(), (Constraint<ColumnHandle>)new Constraint(simplifiedConstraint, bindings -> !this.shouldPrune(constraint, node.getAssignments(), (Map<ColumnHandle, NullableValue>)bindings, context.getCorrelations())), Optional.of(node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableSet.toImmutableSet())));
            if (layouts.isEmpty()) {
                return new PlanWithProperties(new ValuesNode(this.idAllocator.getNextId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()), ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
            }
            Preconditions.checkState((!(layouts = layouts.stream().filter(this.layoutHasAllNeededOutputs(node)).collect(Collectors.toList())).isEmpty() ? 1 : 0) != 0, (String)"No usable layouts for %s", (Object)node);
            List<PlanWithProperties> possiblePlans = layouts.stream().map(arg_0 -> this.lambda$planTableScan$5(node, simplifiedConstraint, predicate, (Map)assignments, decomposedPredicate, arg_0)).collect(Collectors.toList());
            return this.pickPlan(possiblePlans, context);
        }

        private Predicate<TableLayoutResult> layoutHasAllNeededOutputs(TableScanNode node) {
            return layout -> {
                if (!layout.getLayout().getColumns().isPresent()) return true;
                if (!layout.getLayout().getColumns().get().containsAll(Lists.transform(node.getOutputSymbols(), node.getAssignments()::get))) return false;
                return true;
            };
        }

        private PlanWithProperties pickPlan(List<PlanWithProperties> possiblePlans, Context context) {
            Preconditions.checkArgument((!possiblePlans.isEmpty() ? 1 : 0) != 0);
            if (this.preferStreamingOperators) {
                possiblePlans = new ArrayList<PlanWithProperties>(possiblePlans);
                Collections.sort(possiblePlans, Comparator.comparing(PlanWithProperties::getProperties, AddExchanges.streamingExecutionPreference(context.getPreferredProperties())));
            }
            return possiblePlans.get(0);
        }

        private boolean shouldPrune(Expression predicate, Map<Symbol, ColumnHandle> assignments, Map<ColumnHandle, NullableValue> bindings, List<Symbol> correlations) {
            List<Expression> conjuncts = ExpressionUtils.extractConjuncts(predicate);
            IdentityLinkedHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, AddExchanges.this.metadata, AddExchanges.this.parser, this.types, predicate, Collections.emptyList());
            LookupSymbolResolver inputs = new LookupSymbolResolver(assignments, bindings);
            for (Expression expression : conjuncts) {
                ExpressionInterpreter optimizer;
                Object optimized;
                if (DependencyExtractor.extractUnique(expression).stream().anyMatch(correlations::contains) || !Boolean.FALSE.equals(optimized = (optimizer = ExpressionInterpreter.expressionOptimizer(expression, AddExchanges.this.metadata, this.session, expressionTypes)).optimize(inputs)) && optimized != null && !(optimized instanceof NullLiteral)) continue;
                return true;
            }
            return false;
        }

        @Override
        public PlanWithProperties visitValues(ValuesNode node, Context context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType() == ExchangeNode.Type.GATHER) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType().equals((Object)ExchangeNode.Type.GATHER)) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isSingleNode() || !child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private <T> SetMultimap<T, T> createMapping(List<T> keys, List<T> values) {
            Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Inputs must have the same size");
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (int i = 0; i < keys.size(); ++i) {
                builder.put(keys.get(i), values.get(i));
            }
            return builder.build();
        }

        private <T> Function<T, Optional<T>> createTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).stream().findAny();
        }

        private <T> Function<T, T> createDirectTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).iterator().next();
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, Context context) {
            PlanWithProperties right;
            PlanWithProperties left;
            List leftSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
            JoinNode.Type type = node.getType();
            JoinNode.DistributionType distributionType = node.getDistributionType().orElseThrow(() -> new IllegalArgumentException("distributionType not yet set"));
            if (distributionType == JoinNode.DistributionType.PARTITIONED) {
                Partitioning rightPartitioning;
                SetMultimap rightToLeft = this.createMapping(rightSymbols, leftSymbols);
                SetMultimap leftToRight = this.createMapping(leftSymbols, rightSymbols);
                left = node.getLeft().accept(this, context.withPreferredProperties(PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf((Collection)leftSymbols))));
                if (left.getProperties().isNodePartitionedOn(leftSymbols) && !left.getProperties().isSingleNode()) {
                    rightPartitioning = left.getProperties().translate(this.createTranslator(leftToRight)).getNodePartitioning().get();
                    right = node.getRight().accept(this, context.withPreferredProperties(PreferredProperties.partitioned(rightPartitioning)));
                    if (!right.getProperties().isNodePartitionedWith(left.getProperties(), arg_0 -> rightToLeft.get(arg_0))) {
                        right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputSymbols())), right.getProperties());
                    }
                } else {
                    right = node.getRight().accept(this, context.withPreferredProperties(PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf((Collection)rightSymbols))));
                    if (right.getProperties().isNodePartitionedOn(rightSymbols) && !right.getProperties().isSingleNode()) {
                        Partitioning leftPartitioning = right.getProperties().translate(this.createTranslator(rightToLeft)).getNodePartitioning().get();
                        left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, left.getNode(), new PartitioningScheme(leftPartitioning, left.getNode().getOutputSymbols())), left.getProperties());
                    } else {
                        left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, left.getNode(), leftSymbols, Optional.empty()), left.getProperties());
                        right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), rightSymbols, Optional.empty()), right.getProperties());
                    }
                }
                Verify.verify((boolean)left.getProperties().isNodePartitionedWith(right.getProperties(), arg_0 -> leftToRight.get(arg_0)));
                if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleSources(left.getNode(), right.getNode())) {
                    rightPartitioning = left.getProperties().translate(this.createTranslator(leftToRight)).getNodePartitioning().get();
                    right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputSymbols())), right.getProperties());
                }
            } else {
                left = node.getLeft().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                right = node.getRight().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                if (left.getProperties().isSingleNode()) {
                    if (!right.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleSources(left.getNode(), right.getNode())) {
                        right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode()), right.getProperties());
                    }
                } else {
                    right = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode()), right.getProperties());
                }
            }
            JoinNode result = new JoinNode(node.getId(), type, left.getNode(), right.getNode(), node.getCriteria(), node.getOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType());
            return new PlanWithProperties(result, this.deriveProperties((PlanNode)result, (List<ActualProperties>)ImmutableList.of((Object)left.getProperties(), (Object)right.getProperties())));
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, Context context) {
            PreferredProperties translatedPreferred = context.getPreferredProperties().translate(symbol -> node.getReplicateSymbols().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context.withPreferredProperties(translatedPreferred)));
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, Context context) {
            PlanWithProperties filteringSource;
            PlanWithProperties source;
            SemiJoinNode.DistributionType distributionType = node.getDistributionType().orElseThrow(() -> new IllegalArgumentException("distributionType not yet set"));
            if (distributionType == SemiJoinNode.DistributionType.PARTITIONED) {
                Partitioning filteringPartitioning;
                ImmutableList sourceSymbols = ImmutableList.of((Object)node.getSourceJoinSymbol());
                ImmutableList filteringSourceSymbols = ImmutableList.of((Object)node.getFilteringSourceJoinSymbol());
                SetMultimap sourceToFiltering = this.createMapping((List)sourceSymbols, (List)filteringSourceSymbols);
                SetMultimap filteringToSource = this.createMapping((List)filteringSourceSymbols, (List)sourceSymbols);
                source = node.getSource().accept(this, context.withPreferredProperties(PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf((Collection)sourceSymbols))));
                if (source.getProperties().isNodePartitionedOn((Collection<Symbol>)sourceSymbols) && !source.getProperties().isSingleNode()) {
                    filteringPartitioning = source.getProperties().translate(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                    filteringSource = node.getFilteringSource().accept(this, context.withPreferredProperties(PreferredProperties.partitionedWithNullsReplicated(filteringPartitioning)));
                    if (!source.getProperties().withReplicatedNulls(true).isNodePartitionedWith(filteringSource.getProperties(), arg_0 -> sourceToFiltering.get(arg_0))) {
                        filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputSymbols(), Optional.empty(), true, Optional.empty())), filteringSource.getProperties());
                    }
                } else {
                    filteringSource = node.getFilteringSource().accept(this, context.withPreferredProperties(PreferredProperties.partitionedWithNullsReplicated((Set<Symbol>)ImmutableSet.copyOf((Collection)filteringSourceSymbols))));
                    if (filteringSource.getProperties().isNodePartitionedOn((Collection<Symbol>)filteringSourceSymbols, true) && !filteringSource.getProperties().isSingleNode()) {
                        Partitioning sourcePartitioning = filteringSource.getProperties().translate(this.createTranslator(filteringToSource)).getNodePartitioning().get();
                        source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, source.getNode(), new PartitioningScheme(sourcePartitioning, source.getNode().getOutputSymbols())), source.getProperties());
                    } else {
                        source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, source.getNode(), (List<Symbol>)sourceSymbols, Optional.empty()), source.getProperties());
                        filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode(), (List<Symbol>)filteringSourceSymbols, Optional.empty(), true), filteringSource.getProperties());
                    }
                }
                Verify.verify((boolean)source.getProperties().withReplicatedNulls(true).isNodePartitionedWith(filteringSource.getProperties(), arg_0 -> sourceToFiltering.get(arg_0)));
                if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleSources(source.getNode(), filteringSource.getNode())) {
                    filteringPartitioning = source.getProperties().translate(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                    filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputSymbols(), Optional.empty(), true, Optional.empty())), filteringSource.getProperties());
                }
            } else {
                source = node.getSource().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                filteringSource = node.getFilteringSource().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                if (source.getProperties().isSingleNode()) {
                    if (!filteringSource.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleSources(source.getNode(), filteringSource.getNode())) {
                        filteringSource = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode()), filteringSource.getProperties());
                    }
                } else {
                    filteringSource = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode()), filteringSource.getProperties());
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, Context context) {
            List joinColumns = Lists.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getProbe);
            Object desiredLocalProperties = context.getPreferredProperties().getLocalProperties().isEmpty() ? LocalProperties.grouped(joinColumns) : ImmutableList.of();
            PlanWithProperties probeSource = node.getProbeSource().accept(this, context.withPreferredProperties(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf((Collection)joinColumns), (List<? extends LocalProperty<Symbol>>)desiredLocalProperties).mergeWithParent(context.getPreferredProperties())));
            ActualProperties probeProperties = probeSource.getProperties();
            PlanWithProperties indexSource = node.getIndexSource().accept(this, context.withPreferredProperties(PreferredProperties.any()));
            if (this.shouldRepartitionForIndexJoin(joinColumns, context.getPreferredProperties(), probeProperties)) {
                probeSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, probeSource.getNode(), joinColumns, node.getProbeHashSymbol()), probeProperties);
            }
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)probeSource.getNode(), (Object)node.getIndexSource()));
            return new PlanWithProperties(result, this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)probeSource.getProperties(), (Object)indexSource.getProperties())));
        }

        private boolean shouldRepartitionForIndexJoin(List<Symbol> joinColumns, PreferredProperties parentPreferredProperties, ActualProperties probeProperties) {
            if (!this.distributedIndexJoins) {
                return false;
            }
            if (probeProperties.isSingleNode()) {
                return false;
            }
            Optional<Boolean> parentPartitioningPreferences = parentPreferredProperties.getGlobalProperties().flatMap(PreferredProperties.Global::getPartitioningProperties);
            boolean parentAlreadyPartitionedOnChild = parentPartitioningPreferences.map(partitioning -> probeProperties.isStreamPartitionedOn(partitioning.getPartitioningColumns())).orElse(false);
            if (this.preferStreamingOperators && parentAlreadyPartitionedOnChild) {
                return false;
            }
            if (!probeProperties.isStreamPartitionedOn(joinColumns)) {
                return true;
            }
            return probeProperties.isEffectivelySingleStream() && probeProperties.isStreamRepartitionEffective(joinColumns);
        }

        @Override
        public PlanWithProperties visitIndexSource(IndexSourceNode node, Context context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        private Function<Symbol, Optional<Symbol>> outputToInputTranslator(UnionNode node, int sourceIndex) {
            return symbol -> Optional.of(node.getSymbolMapping().get(symbol).get(sourceIndex));
        }

        private Partitioning selectUnionPartitioning(UnionNode node, Context context, PreferredProperties.PartitioningProperties parentPreference) {
            if (parentPreference.getPartitioning().isPresent()) {
                return parentPreference.getPartitioning().get();
            }
            boolean nullsReplicated = parentPreference.isNullsReplicated();
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                PreferredProperties.PartitioningProperties childPartitioning = parentPreference.translate(this.outputToInputTranslator(node, sourceIndex)).get();
                PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(childPartitioning.withNullsReplicated(nullsReplicated))).build();
                PlanWithProperties child = node.getSources().get(sourceIndex).accept(this, context.withPreferredProperties(childPreferred));
                if (!child.getProperties().isNodePartitionedOn(childPartitioning.getPartitioningColumns(), nullsReplicated)) continue;
                Function<Symbol, Optional<Symbol>> childToParent = this.createTranslator(this.createMapping(node.sourceOutputLayout(sourceIndex), node.getOutputSymbols()));
                return child.getProperties().translate(childToParent).getNodePartitioning().get();
            }
            return Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Symbol>)ImmutableList.copyOf(parentPreference.getPartitioningColumns()));
        }

        @Override
        public PlanWithProperties visitUnion(UnionNode node, Context context) {
            PlanNode result;
            PreferredProperties parentPreference = context.getPreferredProperties();
            Optional<PreferredProperties.Global> parentGlobal = parentPreference.getGlobalProperties();
            if (parentGlobal.isPresent() && parentGlobal.get().isDistributed() && parentGlobal.get().getPartitioningProperties().isPresent()) {
                PreferredProperties.PartitioningProperties parentPartitioningPreference = parentGlobal.get().getPartitioningProperties().get();
                boolean nullsReplicated = parentPartitioningPreference.isNullsReplicated();
                Partitioning desiredParentPartitioning = this.selectUnionPartitioning(node, context, parentPartitioningPreference);
                ImmutableList.Builder partitionedSources = ImmutableList.builder();
                ImmutableListMultimap.Builder outputToSourcesMapping = ImmutableListMultimap.builder();
                for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                    Partitioning childPartitioning = desiredParentPartitioning.translate(this.createDirectTranslator(this.createMapping(node.getOutputSymbols(), node.sourceOutputLayout(sourceIndex))));
                    PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(PreferredProperties.PartitioningProperties.partitioned(childPartitioning).withNullsReplicated(nullsReplicated))).build();
                    PlanWithProperties source = node.getSources().get(sourceIndex).accept(this, context.withPreferredProperties(childPreferred));
                    if (!source.getProperties().isNodePartitionedOn(childPartitioning, nullsReplicated)) {
                        source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, source.getNode(), new PartitioningScheme(childPartitioning, source.getNode().getOutputSymbols(), Optional.empty(), nullsReplicated, Optional.empty())), source.getProperties());
                    }
                    partitionedSources.add((Object)source.getNode());
                    for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                        outputToSourcesMapping.put((Object)node.getOutputSymbols().get(i), (Object)node.sourceOutputLayout(sourceIndex).get(i));
                    }
                }
                UnionNode newNode = new UnionNode(node.getId(), (List<PlanNode>)partitionedSources.build(), (ListMultimap<Symbol, Symbol>)outputToSourcesMapping.build(), (List<Symbol>)ImmutableList.copyOf((Collection)outputToSourcesMapping.build().keySet()));
                return new PlanWithProperties(newNode, ActualProperties.builder().global(ActualProperties.Global.partitionedOn(desiredParentPartitioning, Optional.of(desiredParentPartitioning))).build().withReplicatedNulls(parentPartitioningPreference.isNullsReplicated()));
            }
            ArrayList<PlanNode> unpartitionedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> unpartitionedOutputLayouts = new ArrayList<List<Symbol>>();
            ArrayList<PlanNode> partitionedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> partitionedOutputLayouts = new ArrayList<List<Symbol>>();
            List<PlanNode> sources = node.getSources();
            for (int i = 0; i < sources.size(); ++i) {
                PlanWithProperties child = sources.get(i).accept(this, context.withPreferredProperties(PreferredProperties.any()));
                if (child.getProperties().isSingleNode()) {
                    unpartitionedChildren.add(child.getNode());
                    unpartitionedOutputLayouts.add(node.sourceOutputLayout(i));
                    continue;
                }
                partitionedChildren.add(child.getNode());
                partitionedOutputLayouts.add(node.sourceOutputLayout(i));
            }
            if (!partitionedChildren.isEmpty() && unpartitionedChildren.isEmpty()) {
                result = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), partitionedChildren, partitionedOutputLayouts);
            } else if (!unpartitionedChildren.isEmpty()) {
                if (!partitionedChildren.isEmpty()) {
                    List exchangeOutputLayout = (List)node.getOutputSymbols().stream().map(outputSymbol -> this.symbolAllocator.newSymbol(outputSymbol.getName(), this.types.get(outputSymbol))).collect(ImmutableList.toImmutableList());
                    ExchangeNode result2 = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), exchangeOutputLayout), partitionedChildren, partitionedOutputLayouts);
                    unpartitionedChildren.add(result2);
                    unpartitionedOutputLayouts.add(((PlanNode)result2).getOutputSymbols());
                }
                ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
                for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                    for (List list : unpartitionedOutputLayouts) {
                        mappings.put((Object)node.getOutputSymbols().get(i), list.get(i));
                    }
                }
                result = new UnionNode(node.getId(), unpartitionedChildren, (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet()));
            } else {
                throw new IllegalStateException("both unpartitionedChildren partitionedChildren are empty");
            }
            return new PlanWithProperties(result, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, Context context) {
            PlanWithProperties input = node.getInput().accept(this, context);
            PlanWithProperties subquery = node.getSubquery().accept(this, context.withCorrelations(node.getCorrelation()));
            ApplyNode rewritten = new ApplyNode(node.getId(), input.getNode(), subquery.getNode(), node.getSubqueryAssignments(), node.getCorrelation());
            return new PlanWithProperties(rewritten, this.deriveProperties((PlanNode)rewritten, (List<ActualProperties>)ImmutableList.of((Object)input.getProperties(), (Object)subquery.getProperties())));
        }

        private PlanWithProperties planChild(PlanNode node, Context context) {
            return ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, context);
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, PlanWithProperties child) {
            return this.withDerivedProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child.getNode())), child.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = ChildReplacer.replaceChildren(node, children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            return new PlanWithProperties(result, this.deriveProperties(result, children.stream().map(PlanWithProperties::getProperties).collect(Collectors.toList())));
        }

        private PlanWithProperties withDerivedProperties(PlanNode node, ActualProperties inputProperties) {
            return new PlanWithProperties(node, this.deriveProperties(node, inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, ActualProperties inputProperties) {
            return PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.metadata, this.session, this.types, AddExchanges.this.parser);
        }

        private ActualProperties deriveProperties(PlanNode result, List<ActualProperties> inputProperties) {
            return PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.metadata, this.session, this.types, AddExchanges.this.parser);
        }

        private /* synthetic */ PlanWithProperties lambda$planTableScan$5(TableScanNode node, TupleDomain simplifiedConstraint, Expression predicate, Map assignments, DomainTranslator.ExtractionResult decomposedPredicate, TableLayoutResult layout) {
            TableScanNode tableScan = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), Optional.of(layout.getLayout().getHandle()), (TupleDomain<ColumnHandle>)simplifiedConstraint.intersect(layout.getLayout().getPredicate()), Optional.ofNullable(node.getOriginalConstraint()).orElse(predicate));
            PlanWithProperties result = new PlanWithProperties(tableScan, this.deriveProperties((PlanNode)tableScan, (List<ActualProperties>)ImmutableList.of()));
            Expression[] expressionArray = new Expression[3];
            expressionArray[0] = DomainTranslator.toPredicate((TupleDomain<Symbol>)layout.getUnenforcedConstraint().transform(assignments::get));
            expressionArray[1] = ExpressionUtils.stripDeterministicConjuncts(predicate);
            expressionArray[2] = decomposedPredicate.getRemainingExpression();
            Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
                return this.withDerivedProperties(new FilterNode(this.idAllocator.getNextId(), result.getNode(), resultingPredicate), this.deriveProperties((PlanNode)tableScan, (List<ActualProperties>)ImmutableList.of()));
            }
            return result;
        }
    }

    private static class Context {
        private final PreferredProperties preferredProperties;
        private final List<Symbol> correlations;

        Context(PreferredProperties preferredProperties, List<Symbol> correlations) {
            this.preferredProperties = preferredProperties;
            this.correlations = ImmutableList.copyOf((Collection)Objects.requireNonNull(correlations, "correlations is null"));
        }

        Context withPreferredProperties(PreferredProperties preferredProperties) {
            return new Context(preferredProperties, this.correlations);
        }

        Context withCorrelations(List<Symbol> correlations) {
            return new Context(this.preferredProperties, correlations);
        }

        PreferredProperties getPreferredProperties() {
            return this.preferredProperties;
        }

        List<Symbol> getCorrelations() {
            return this.correlations;
        }
    }
}

