/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToScalarApply
implements Rule {
    private static final QualifiedName COUNT = QualifiedName.of((String)"count");
    private static final FunctionCall COUNT_CALL = new FunctionCall(COUNT, (List)ImmutableList.of());
    private final Signature countSignature;

    public TransformExistsApplyToScalarApply(FunctionRegistry functionRegistry) {
        Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        this.countSignature = functionRegistry.resolveFunction(COUNT, (List<TypeSignatureProvider>)ImmutableList.of());
    }

    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof ApplyNode)) {
            return Optional.empty();
        }
        ApplyNode parent = (ApplyNode)node;
        if (parent.getSubqueryAssignments().size() != 1) {
            return Optional.empty();
        }
        Expression expression = (Expression)Iterables.getOnlyElement(parent.getSubqueryAssignments().getExpressions());
        if (!(expression instanceof ExistsPredicate)) {
            return Optional.empty();
        }
        Symbol count = symbolAllocator.newSymbol(COUNT.toString(), (Type)BigintType.BIGINT);
        Symbol exists = (Symbol)Iterables.getOnlyElement(parent.getSubqueryAssignments().getSymbols());
        return Optional.of(new ApplyNode(node.getId(), parent.getInput(), new ProjectNode(idAllocator.getNextId(), new AggregationNode(idAllocator.getNextId(), new LimitNode(idAllocator.getNextId(), parent.getSubquery(), 1L, false), (Map<Symbol, FunctionCall>)ImmutableMap.of((Object)count, (Object)COUNT_CALL), (Map<Symbol, Signature>)ImmutableMap.of((Object)count, (Object)this.countSignature), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), Assignments.of(exists, (Expression)new ComparisonExpression(ComparisonExpressionType.GREATER_THAN, (Expression)count.toSymbolReference(), (Expression)new Cast((Expression)new LongLiteral("0"), BigintType.BIGINT.toString())))), Assignments.of(exists, (Expression)exists.toSymbolReference()), parent.getCorrelation()));
    }
}

