/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import java.util.Optional;

public class MergeLimitWithSort
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof LimitNode)) {
            return Optional.empty();
        }
        LimitNode parent = (LimitNode)node;
        PlanNode source = lookup.resolve(parent.getSource());
        if (!(source instanceof SortNode)) {
            return Optional.empty();
        }
        SortNode child = (SortNode)source;
        return Optional.of(new TopNNode(parent.getId(), child.getSource(), parent.getCount(), child.getOrderBy(), child.getOrderings(), parent.isPartial()));
    }
}

