/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class ImplementBernoulliSampleAsFilter
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof SampleNode)) {
            return Optional.empty();
        }
        SampleNode sample = (SampleNode)node;
        if (sample.getSampleType() != SampleNode.Type.BERNOULLI) {
            return Optional.empty();
        }
        return Optional.of(new FilterNode(node.getId(), sample.getSource(), (Expression)new ComparisonExpression(ComparisonExpressionType.LESS_THAN, (Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of()), (Expression)new DoubleLiteral(Double.toString(sample.getSampleRatio())))));
    }
}

