/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.maps.IdentityLinkedHashMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.session = session;
        this.planOptimizers = planOptimizers;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.sqlParser = sqlParser;
    }

    public Plan plan(Analysis analysis) {
        return this.plan(analysis, Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan plan(Analysis analysis, Stage stage) {
        PlanNode root = this.planStatement(analysis, analysis.getStatement());
        if (stage.ordinal() >= Stage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator);
                Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
            }
        }
        if (stage.ordinal() >= Stage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            PlanSanityChecker.validate(root, this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes());
        }
        return new Plan(root, this.symbolAllocator.getTypes());
    }

    public PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect && analysis.isCreateTableAsSelectNoOp()) {
            Preconditions.checkState((boolean)analysis.getCreateTableDestination().isPresent(), (Object)"Table destination is missing");
            Symbol symbol = this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT);
            ValuesNode source = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of((Object)symbol), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("0"))));
            return new OutputNode(this.idAllocator.getNextId(), source, (List<String>)ImmutableList.of((Object)"rows"), (List<Symbol>)ImmutableList.of((Object)symbol));
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect) {
            if (analysis.isCreateTableAsSelectNoOp()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE IF NOT EXISTS is not supported in this context " + statement.getClass().getSimpleName());
            }
            return this.createTableCreationPlan(analysis, ((CreateTableAsSelect)statement).getQuery());
        }
        if (statement instanceof Insert) {
            Preconditions.checkState((boolean)analysis.getInsert().isPresent(), (Object)"Insert handle is missing");
            return this.createInsertPlan(analysis, (Insert)statement);
        }
        if (statement instanceof Delete) {
            return this.createDeletePlan(analysis, (Delete)statement);
        }
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement);
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze()) {
            return this.createExplainAnalyzePlan(analysis, (Explain)statement);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type " + statement.getClass().getSimpleName());
    }

    private RelationPlan createExplainAnalyzePlan(Analysis analysis, Explain statement) {
        RelationPlan underlyingPlan = this.planStatementWithoutOutput(analysis, statement.getStatement());
        PlanNode root = underlyingPlan.getRoot();
        Scope scope = analysis.getScope((Node)statement);
        Symbol outputSymbol = this.symbolAllocator.newSymbol(scope.getRelationType().getFieldByIndex(0));
        root = new ExplainAnalyzeNode(this.idAllocator.getNextId(), root, outputSymbol);
        return new RelationPlan(root, scope, (List<Symbol>)ImmutableList.of((Object)outputSymbol));
    }

    private RelationPlan createTableCreationPlan(Analysis analysis, Query query) {
        QualifiedObjectName destination = analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis, query);
        ConnectorTableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan), analysis.getCreateTableProperties(), analysis.getParameters());
        Optional<NewTableLayout> newTableLayout = this.metadata.getNewTableLayout(this.session, destination.getCatalogName(), tableMetadata);
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.CreateName(destination.getCatalogName(), tableMetadata, newTableLayout), columnNames, newTableLayout);
    }

    private RelationPlan createInsertPlan(Analysis analysis, Insert insertStatement) {
        Analysis.Insert insert = analysis.getInsert().get();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, insert.getTarget());
        List visibleTableColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
        List visibleTableColumnNames = (List)visibleTableColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        RelationPlan plan = this.createRelationPlan(analysis, insertStatement.getQuery());
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, insert.getTarget());
        Assignments.Builder assignments = Assignments.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            if (column2.isHidden()) continue;
            Symbol output = this.symbolAllocator.newSymbol(column2.getName(), column2.getType());
            int index = insert.getColumns().indexOf(columns.get(column2.getName()));
            if (index < 0) {
                assignments.put(output, (Expression)new NullLiteral());
                continue;
            }
            Symbol input = plan.getSymbol(index);
            Type tableType = column2.getType();
            Type queryType = this.symbolAllocator.getTypes().get(input);
            if (queryType.equals(tableType) || this.metadata.getTypeManager().isTypeOnlyCoercion(queryType, tableType)) {
                assignments.put(output, (Expression)input.toSymbolReference());
                continue;
            }
            Cast cast = new Cast((Expression)input.toSymbolReference(), tableType.getTypeSignature().toString());
            assignments.put(output, (Expression)cast);
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        List fields = (List)visibleTableColumns.stream().map(column -> Field.newUnqualified(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        Scope scope = Scope.builder().withRelationType(new RelationType(fields)).build();
        plan = new RelationPlan(projectNode, scope, projectNode.getOutputSymbols());
        Optional<NewTableLayout> newTableLayout = this.metadata.getInsertLayout(this.session, insert.getTarget());
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.InsertReference(insert.getTarget()), visibleTableColumnNames, newTableLayout);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames, Optional<NewTableLayout> writeTableLayout) {
        ImmutableList writerOutputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        PlanNode source = plan.getRoot();
        if (!analysis.isCreateTableAsSelectWithData()) {
            source = new LimitNode(this.idAllocator.getNextId(), source, 0L, false);
        }
        writeTableLayout.ifPresent(layout -> {
            if (!ImmutableSet.copyOf((Collection)columnNames).containsAll(layout.getPartitionColumns())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
            }
        });
        List<Symbol> symbols = plan.getFieldMappings();
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        if (writeTableLayout.isPresent()) {
            ArrayList<Symbol> partitionFunctionArguments = new ArrayList<Symbol>();
            writeTableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(symbols::get).forEach(partitionFunctionArguments::add);
            ArrayList<Symbol> outputLayout = new ArrayList<Symbol>(symbols);
            partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(writeTableLayout.get().getPartitioning(), partitionFunctionArguments), outputLayout));
        }
        TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), source, target, symbols, columnNames, (List<Symbol>)writerOutputs, partitioningScheme);
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), writerNode, target, (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getRootScope(), (List<Symbol>)outputs);
    }

    private RelationPlan createDeletePlan(Analysis analysis, Delete node) {
        DeleteNode deleteNode = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.metadata, this.session).plan(node);
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), deleteNode, deleteNode.getTarget(), (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getScope((Node)node), commitNode.getOutputSymbols());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query) {
        return (RelationPlan)new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.metadata, this.session).process((Node)query, null);
    }

    private ConnectorTableMetadata createTableMetadata(QualifiedObjectName table, List<ColumnMetadata> columns, Map<String, Expression> propertyExpressions, List<Expression> parameters) {
        ConnectorId connectorId = this.metadata.getCatalogHandle(this.session, table.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + table.getCatalogName()));
        Map<String, Object> properties = this.metadata.getTablePropertyManager().getProperties(connectorId, table.getCatalogName(), propertyExpressions, this.session, this.metadata, parameters);
        return new ConnectorTableMetadata(table.asSchemaTableName(), columns, properties);
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            columns.add((Object)new ColumnMetadata(field.getName().get(), field.getType()));
        }
        return columns.build();
    }

    private static IdentityLinkedHashMap<LambdaArgumentDeclaration, Symbol> buildLambdaDeclarationToSymbolMap(Analysis analysis, SymbolAllocator symbolAllocator) {
        IdentityLinkedHashMap<LambdaArgumentDeclaration, Symbol> resultMap = new IdentityLinkedHashMap<LambdaArgumentDeclaration, Symbol>();
        for (Map.Entry<Expression, Type> entry : analysis.getTypes().entrySet()) {
            LambdaArgumentDeclaration lambdaArgumentDeclaration;
            if (!(entry.getKey() instanceof LambdaArgumentDeclaration) || resultMap.containsKey(lambdaArgumentDeclaration = (LambdaArgumentDeclaration)entry.getKey())) continue;
            resultMap.put(lambdaArgumentDeclaration, symbolAllocator.newSymbol((Expression)lambdaArgumentDeclaration, entry.getValue()));
        }
        return resultMap;
    }

    public static enum Stage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

