/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NullIfCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Scope scope = generatorContext.getScope();
        RowExpression first = arguments.get(0);
        RowExpression second = arguments.get(1);
        LabelNode notMatch = new LabelNode("notMatch");
        BytecodeBlock block = new BytecodeBlock().comment("check if first arg is null").append(generatorContext.generate(first)).append(BytecodeUtils.ifWasNullPopAndGoto(scope, notMatch, Void.TYPE, new Class[0]));
        Type firstType = first.getType();
        Type secondType = second.getType();
        Signature equalsSignature = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)firstType, (Object)secondType));
        ScalarFunctionImplementation equalsFunction = generatorContext.getRegistry().getScalarFunctionImplementation(equalsSignature);
        BytecodeNode equalsCall = generatorContext.generateCall(equalsSignature.getName(), equalsFunction, (List<BytecodeNode>)ImmutableList.of((Object)NullIfCodeGenerator.cast(generatorContext, (BytecodeNode)new BytecodeBlock().dup(firstType.getJavaType()), firstType, equalsSignature.getArgumentTypes().get(0)), (Object)NullIfCodeGenerator.cast(generatorContext, generatorContext.generate(second), secondType, equalsSignature.getArgumentTypes().get(1))));
        BytecodeBlock conditionBlock = new BytecodeBlock().append(equalsCall).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, notMatch, Void.TYPE, Boolean.TYPE));
        BytecodeBlock trueBlock = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pop(first.getType().getJavaType()).pushJavaDefault(first.getType().getJavaType());
        block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)conditionBlock).ifTrue((BytecodeNode)trueBlock).ifFalse((BytecodeNode)notMatch));
        return block;
    }

    private static BytecodeNode cast(BytecodeGeneratorContext generatorContext, BytecodeNode argument, Type actualType, TypeSignature requiredType) {
        if (actualType.getTypeSignature().equals((Object)requiredType)) {
            return argument;
        }
        Signature function = generatorContext.getRegistry().getCoercion(actualType.getTypeSignature(), requiredType);
        return generatorContext.generateCall(function.getName(), generatorContext.getRegistry().getScalarFunctionImplementation(function), (List<BytecodeNode>)ImmutableList.of((Object)argument));
    }
}

