/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.ParameterAndType;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class LambdaBytecodeGenerator {
    private LambdaBytecodeGenerator() {
    }

    public static FieldDefinition preGenerateLambdaExpression(LambdaDefinitionExpression lambdaExpression, String fieldName, ClassDefinition classDefinition, PreGeneratedExpressions preGeneratedExpressions, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionRegistry functionRegistry) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        ImmutableMap.Builder parameterMapBuilder = ImmutableMap.builder();
        parameters.add((Object)Parameter.arg((String)"session", ConnectorSession.class));
        for (int i = 0; i < lambdaExpression.getArguments().size(); ++i) {
            Class type = Primitives.wrap((Class)lambdaExpression.getArgumentTypes().get(i).getJavaType());
            String argumentName = lambdaExpression.getArguments().get(i);
            Parameter arg = Parameter.arg((String)("lambda_" + argumentName), (Class)type);
            parameters.add((Object)arg);
            parameterMapBuilder.put((Object)argumentName, (Object)new ParameterAndType(arg, type));
        }
        BytecodeExpressionVisitor innerExpressionVisitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, LambdaBytecodeGenerator.variableReferenceCompiler((Map<String, ParameterAndType>)parameterMapBuilder.build()), functionRegistry, preGeneratedExpressions);
        return LambdaBytecodeGenerator.defineLambdaMethodAndField(innerExpressionVisitor, classDefinition, fieldName, (List<Parameter>)parameters.build(), lambdaExpression);
    }

    private static FieldDefinition defineLambdaMethodAndField(BytecodeExpressionVisitor innerExpressionVisitor, ClassDefinition classDefinition, String fieldAndMethodName, List<Parameter> inputParameters, LambdaDefinitionExpression lambda) {
        Class returnType = Primitives.wrap((Class)lambda.getBody().getType().getJavaType());
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), fieldAndMethodName, ParameterizedType.type((Class)returnType), inputParameters);
        Scope scope = method.getScope();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        BytecodeNode compiledBody = lambda.getBody().accept(innerExpressionVisitor, scope);
        method.getBody().putVariable(wasNull, false).append(compiledBody).append(BytecodeUtils.boxPrimitiveIfNecessary(scope, returnType)).ret(returnType);
        FieldDefinition methodHandleField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC, Access.FINAL}), fieldAndMethodName, ParameterizedType.type(MethodHandle.class));
        classDefinition.getClassInitializer().getBody().append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)methodHandleField, (BytecodeExpression)BytecodeExpressions.invokeStatic(Reflection.class, (String)"methodHandle", MethodHandle.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)classDefinition.getType()), BytecodeExpressions.constantString((String)fieldAndMethodName), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Class[].class), (Iterable)((Iterable)inputParameters.stream().map(BytecodeExpression::getType).map(BytecodeExpressions::constantClass).collect(ImmutableList.toImmutableList())))})));
        return methodHandleField;
    }

    private static RowExpressionVisitor<Scope, BytecodeNode> variableReferenceCompiler(final Map<String, ParameterAndType> parameterMap) {
        return new RowExpressionVisitor<Scope, BytecodeNode>(){

            @Override
            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                ParameterAndType parameterAndType = (ParameterAndType)parameterMap.get(reference.getName());
                Parameter parameter = parameterAndType.getParameter();
                Class<?> type = parameterAndType.getType();
                return new BytecodeBlock().append((BytecodeNode)parameter).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context, type));
            }
        };
    }
}

