/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class BindCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        BytecodeBlock block = new BytecodeBlock().setDescription("Partial apply");
        Scope scope = context.getScope();
        Variable wasNull = scope.getVariable("wasNull");
        Class valueType = Primitives.wrap((Class)arguments.get(0).getType().getJavaType());
        Variable valueVariable = scope.createTempVariable(valueType);
        block.append(context.generate(arguments.get(0)));
        block.append(BytecodeUtils.boxPrimitiveIfNecessary(scope, valueType));
        block.putVariable(valueVariable);
        block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        Variable functionVariable = scope.createTempVariable(MethodHandle.class);
        block.append(context.generate(arguments.get(1)));
        block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNull).ifFalse((BytecodeNode)new BytecodeBlock().putVariable(functionVariable).append((BytecodeNode)BytecodeExpressions.invokeStatic(MethodHandles.class, (String)"insertArguments", MethodHandle.class, (BytecodeExpression[])new BytecodeExpression[]{functionVariable, BytecodeExpressions.constantInt((int)0), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Object[].class), (Iterable)ImmutableList.of((Object)valueVariable.cast(Object.class)))}))));
        return block;
    }
}

