/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class ScopeReferenceExtractor {
    private ScopeReferenceExtractor() {
    }

    public static boolean hasReferencesToScope(Node node, Analysis analysis, Scope scope) {
        return !ScopeReferenceExtractor.getReferencesToScope(node, analysis, scope).isEmpty();
    }

    public static List<Expression> getReferencesToScope(Node node, Analysis analysis, Scope scope) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new Visitor(analysis, scope).process(node, builder);
        return builder.build();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<Expression>> {
        private final Analysis analysis;
        private final Scope scope;

        private Visitor(Analysis analysis, Scope scope) {
            this.analysis = Objects.requireNonNull(analysis, "analysis is null");
            this.scope = Objects.requireNonNull(scope, "scope is null");
        }

        protected Void visitIdentifier(Identifier node, ImmutableList.Builder<Expression> context) {
            if (!this.analysis.getLambdaArgumentReferences().containsKey(node) && this.isReferenceToScope((Expression)node, QualifiedName.of((String)node.getName()))) {
                context.add((Object)node);
            }
            return null;
        }

        protected Void visitLambdaExpression(LambdaExpression node, ImmutableList.Builder<Expression> context) {
            return (Void)this.process((Node)node.getBody(), context);
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableList.Builder<Expression> context) {
            if (this.analysis.getColumnReferences().contains(node) && this.isReferenceToScope((Expression)node, DereferenceExpression.getQualifiedName((DereferenceExpression)node))) {
                context.add((Object)node);
                return null;
            }
            return (Void)super.visitDereferenceExpression(node, context);
        }

        private boolean isReferenceToScope(Expression node, QualifiedName qualifiedName) {
            Optional<ResolvedField> resolvedField = this.scope.tryResolveField(node, qualifiedName);
            return resolvedField.isPresent() && resolvedField.get().getScope().equals(this.scope);
        }
    }
}

