/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class LambdaReferenceExtractor {
    private LambdaReferenceExtractor() {
    }

    public static boolean hasReferencesToLambdaArgument(Node node, Analysis analysis) {
        return !LambdaReferenceExtractor.getReferencesToLambdaArgument(node, analysis).isEmpty();
    }

    public static List<Expression> getReferencesToLambdaArgument(Node node, Analysis analysis) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new Visitor(analysis).process(node, builder);
        return builder.build();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<Expression>> {
        private final Analysis analysis;

        private Visitor(Analysis analysis) {
            this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        }

        protected Void visitIdentifier(Identifier node, ImmutableList.Builder<Expression> context) {
            if (this.analysis.getLambdaArgumentReferences().containsKey(node)) {
                context.add((Object)node);
            }
            return null;
        }
    }
}

