/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;

@Path(value="/v1/queryState")
public class QueryStateInfoResource {
    private final QueryManager queryManager;
    private final ResourceGroupManager resourceGroupManager;

    @Inject
    public QueryStateInfoResource(QueryManager queryManager, ResourceGroupManager resourceGroupManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @GET
    public List<QueryStateInfo> getQueryDiagnosticsByUser(@QueryParam(value="user") String user) {
        if (Strings.isNullOrEmpty((String)user)) {
            return ImmutableList.of();
        }
        List userQueries = (List)this.queryManager.getAllQueryInfo().stream().filter(queryInfo -> Pattern.matches(user, queryInfo.getSession().getUser())).filter(queryInfo -> !queryInfo.getState().isDone()).collect(ImmutableList.toImmutableList());
        Map rootResourceGroupInfos = (Map)userQueries.stream().map(queryInfo -> this.queryManager.getQueryResourceGroup(queryInfo.getQueryId())).filter(Optional::isPresent).map(Optional::get).map(ResourceGroupId::getRoot).distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), this.resourceGroupManager::getResourceGroupInfo));
        return (List)userQueries.stream().map(queryInfo -> QueryStateInfo.createQueryStateInfo(queryInfo, this.queryManager.getQueryResourceGroup(queryInfo.getQueryId()), this.queryManager.getQueryResourceGroup(queryInfo.getQueryId()).map(ResourceGroupId::getRoot).map(rootResourceGroupInfos::get))).collect(ImmutableList.toImmutableList());
    }
}

